/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.impl.CounterOperationFactory;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.exception.CounterException;

abstract class BaseCounterOperation<T>
extends RetryOnFailureOperation<T> {
    private static final Log commonsLog = LogFactory.getLog(BaseCounterOperation.class, Log.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final byte[] EMPTY_CACHE_NAME = Util.EMPTY_BYTE_ARRAY;
    private final String counterName;
    private final boolean useConsistentHash;

    BaseCounterOperation(short requestCode, short responseCode, Codec codec, ChannelFactory channelFactory, AtomicInteger topologyId, Configuration cfg, String counterName, boolean useConsistentHash) {
        super(requestCode, responseCode, codec, channelFactory, EMPTY_CACHE_NAME, topologyId, 0, cfg, null);
        this.counterName = counterName;
        this.useConsistentHash = useConsistentHash;
    }

    void sendHeaderAndCounterNameAndRead(Channel channel) {
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, 0);
        channel.writeAndFlush(buf);
    }

    ByteBuf getHeaderAndCounterNameBufferAndRead(Channel channel, int extraBytes) {
        this.scheduleRead(channel);
        byte[] counterBytes = this.counterName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(counterBytes) + extraBytes);
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeString(buf, this.counterName);
        this.setCacheName();
        return buf;
    }

    void checkStatus(short status) {
        if (status == 2) {
            throw commonsLog.undefinedCounter(this.counterName);
        }
    }

    void setCacheName() {
        this.header.cacheName(CounterOperationFactory.COUNTER_CACHE_NAME);
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (retryCount == 0 && this.useConsistentHash) {
            this.channelFactory.fetchChannelAndInvoke(new ByteString(this.counterName), failedServers, CounterOperationFactory.COUNTER_CACHE_NAME, this);
        } else {
            this.channelFactory.fetchChannelAndInvoke(failedServers, CounterOperationFactory.COUNTER_CACHE_NAME, this);
        }
    }

    @Override
    protected Throwable handleException(Throwable cause, Channel channel, SocketAddress address) {
        if ((cause = super.handleException(cause, channel, address)) instanceof CounterException) {
            this.completeExceptionally(cause);
            return null;
        }
        return cause;
    }

    @Override
    protected void addParams(StringBuilder sb) {
        sb.append("counter=").append(this.counterName);
    }

    private class ByteString {
        private final int hash;
        private final byte[] b;

        private ByteString(String s) {
            this.b = s.getBytes(CHARSET);
            this.hash = Arrays.hashCode(this.b);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteString that = (ByteString)o;
            return Arrays.equals(this.b, that.b);
        }

        public String toString() {
            return new String(this.b, CHARSET);
        }
    }
}

