/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.tx;

import java.util.UUID;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public abstract class TransactionManagerImpl
implements TransactionManager {
    private static final Log log = LogFactory.getLog(TransactionManagerImpl.class);
    private static final ThreadLocal<Transaction> CURRENT_TRANSACTION = new ThreadLocal();
    protected final UUID transactionManagerId = UUID.randomUUID();

    public static void dissociateTransaction() {
        CURRENT_TRANSACTION.remove();
    }

    static void associateTransaction(Transaction tx) {
        CURRENT_TRANSACTION.set(tx);
    }

    @Override
    public Transaction getTransaction() {
        return CURRENT_TRANSACTION.get();
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        Transaction currentTx = this.getTransaction();
        if (currentTx != null) {
            throw new NotSupportedException(Thread.currentThread() + " is already associated with a transaction (" + currentTx + ")");
        }
        TransactionManagerImpl.associateTransaction(this.createTransaction());
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getTransactionAndFailIfNone().commit();
        TransactionManagerImpl.dissociateTransaction();
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getTransactionAndFailIfNone().rollback();
        TransactionManagerImpl.dissociateTransaction();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getTransactionAndFailIfNone().setRollbackOnly();
    }

    @Override
    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    @Override
    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new SystemException("not supported");
    }

    @Override
    public Transaction suspend() throws SystemException {
        Transaction tx = this.getTransaction();
        TransactionManagerImpl.dissociateTransaction();
        if (log.isTraceEnabled()) {
            log.tracef("Suspending tx %s", (Object)tx);
        }
        return tx;
    }

    @Override
    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (log.isTraceEnabled()) {
            log.tracef("Resuming tx %s", (Object)tx);
        }
        TransactionManagerImpl.associateTransaction(tx);
    }

    protected abstract Transaction createTransaction();

    private Transaction getTransactionAndFailIfNone() {
        Transaction transaction = CURRENT_TRANSACTION.get();
        if (transaction == null) {
            throw new IllegalStateException("no transaction associated with calling thread");
        }
        return transaction;
    }
}

