/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.models.PMMLModel;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;

public abstract class KiePMMLModel
extends AbstractKiePMMLComponent
implements PMMLModel {
    protected PMML_MODEL pmmlMODEL;
    protected MINING_FUNCTION miningFunction;
    protected String targetField;
    protected Map<String, Object> outputFieldsMap = new HashMap<String, Object>();
    protected Map<String, Object> missingValueReplacementMap = new HashMap<String, Object>();
    protected Map<String, Function<List<KiePMMLNameValue>, Object>> commonTransformationsMap = new HashMap<String, Function<List<KiePMMLNameValue>, Object>>();
    protected Map<String, Function<List<KiePMMLNameValue>, Object>> localTransformationsMap = new HashMap<String, Function<List<KiePMMLNameValue>, Object>>();
    protected Map<String, BiFunction<List<KiePMMLNameValue>, Object, Object>> functionsMap = new HashMap<String, BiFunction<List<KiePMMLNameValue>, Object, Object>>();
    protected List<MiningField> miningFields = new ArrayList<MiningField>();
    protected List<OutputField> outputFields = new ArrayList<OutputField>();
    protected List<KiePMMLOutputField> kiePMMLOutputFields = new ArrayList<KiePMMLOutputField>();
    protected List<KiePMMLTarget> kiePMMLTargets = new ArrayList<KiePMMLTarget>();

    protected KiePMMLModel(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    public PMML_MODEL getPmmlMODEL() {
        return this.pmmlMODEL;
    }

    public MINING_FUNCTION getMiningFunction() {
        return this.miningFunction;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public Map<String, Object> getOutputFieldsMap() {
        return Collections.unmodifiableMap(this.outputFieldsMap);
    }

    public Map<String, Object> getMissingValueReplacementMap() {
        return Collections.unmodifiableMap(this.missingValueReplacementMap);
    }

    public Map<String, Function<List<KiePMMLNameValue>, Object>> getCommonTransformationsMap() {
        return Collections.unmodifiableMap(this.commonTransformationsMap);
    }

    public Map<String, Function<List<KiePMMLNameValue>, Object>> getLocalTransformationsMap() {
        return Collections.unmodifiableMap(this.localTransformationsMap);
    }

    public Map<String, BiFunction<List<KiePMMLNameValue>, Object, Object>> getFunctionsMap() {
        return Collections.unmodifiableMap(this.functionsMap);
    }

    public String getKModulePackageName() {
        String className = this.getClass().getCanonicalName();
        return className.substring(0, className.lastIndexOf(46));
    }

    @Override
    public List<MiningField> getMiningFields() {
        return this.miningFields;
    }

    public void setMiningFields(List<MiningField> miningFields) {
        this.miningFields = Collections.unmodifiableList(miningFields);
    }

    @Override
    public List<OutputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<OutputField> outputFields) {
        this.outputFields = Collections.unmodifiableList(outputFields);
    }

    public void setKiePMMLOutputFields(List<KiePMMLOutputField> kiePMMLOutputFields) {
        this.kiePMMLOutputFields = Collections.unmodifiableList(kiePMMLOutputFields);
    }

    public List<KiePMMLTarget> getKiePMMLTargets() {
        return this.kiePMMLTargets;
    }

    public void setKiePMMLTargets(List<KiePMMLTarget> kiePMMLTargets) {
        this.kiePMMLTargets = Collections.unmodifiableList(kiePMMLTargets);
    }

    public List<KiePMMLOutputField> getKiePMMLOutputFields() {
        return Collections.unmodifiableList(this.kiePMMLOutputFields);
    }

    public abstract Object evaluate(Object var1, Map<String, Object> var2);

    public static abstract class Builder<T extends KiePMMLModel>
    extends AbstractKiePMMLComponent.Builder<T> {
        protected Builder(String prefix, PMML_MODEL pmmlMODEL, MINING_FUNCTION miningFunction, Supplier<T> supplier) {
            super(prefix, supplier);
            ((KiePMMLModel)this.toBuild).pmmlMODEL = pmmlMODEL;
            ((KiePMMLModel)this.toBuild).miningFunction = miningFunction;
        }

        public Builder<T> withTargetField(String targetField) {
            ((KiePMMLModel)this.toBuild).targetField = targetField;
            return this;
        }

        public Builder<T> withOutputFieldsMap(Map<String, Object> outputFieldsMap) {
            ((KiePMMLModel)this.toBuild).outputFieldsMap.putAll(outputFieldsMap);
            return this;
        }

        public Builder<T> withMissingValueReplacementMap(Map<String, Object> missingValueReplacementMap) {
            ((KiePMMLModel)this.toBuild).missingValueReplacementMap.putAll(missingValueReplacementMap);
            return this;
        }
    }
}

