/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;

public class KiePMMLTargetValue
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = -4948552909458142415L;
    private String value;
    private String displayValue;
    private Double priorProbability;
    private Double defaultValue;

    private KiePMMLTargetValue(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions) {
        return new Builder(name, extensions);
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public Double getPriorProbability() {
        return this.priorProbability;
    }

    public Double getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KiePMMLTargetValue that = (KiePMMLTargetValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.displayValue, that.displayValue) && Objects.equals(this.priorProbability, that.priorProbability) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.displayValue, this.priorProbability, this.defaultValue);
    }

    public String toString() {
        return new StringJoiner(", ", KiePMMLTargetValue.class.getSimpleName() + "[", "]").add("value='" + this.value + "'").add("displayValue='" + this.displayValue + "'").add("priorProbability=" + this.priorProbability).add("defaultValue=" + this.defaultValue).add("name='" + this.name + "'").add("extensions=" + this.extensions).add("id='" + this.id + "'").add("parentId='" + this.parentId + "'").toString();
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLTargetValue> {
        private Builder(String name, List<KiePMMLExtension> extensions) {
            super("TargetValue-", () -> new KiePMMLTargetValue(name, extensions));
        }

        public Builder withValue(String value) {
            if (value != null) {
                ((KiePMMLTargetValue)this.toBuild).value = value;
            }
            return this;
        }

        public Builder withDisplayValue(String displayValue) {
            if (displayValue != null) {
                ((KiePMMLTargetValue)this.toBuild).displayValue = displayValue;
            }
            return this;
        }

        public Builder withPriorProbability(Number priorProbability) {
            if (priorProbability != null) {
                ((KiePMMLTargetValue)this.toBuild).priorProbability = priorProbability.doubleValue();
            }
            return this;
        }

        public Builder withDefaultValue(Number defaultValue) {
            if (defaultValue != null) {
                ((KiePMMLTargetValue)this.toBuild).defaultValue = defaultValue.doubleValue();
            }
            return this;
        }
    }
}

