/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.io.jar;

import java.lang.reflect.Method;
import java.util.jar.JarEntry;

public class JarEntries {
    private static final Method REAL_NAME_METHOD;

    public static String getRealName(JarEntry jarEntry) {
        if (REAL_NAME_METHOD != null) {
            try {
                return REAL_NAME_METHOD.invoke((Object)jarEntry, new Object[0]).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jarEntry.getName();
    }

    static {
        Method method;
        try {
            method = Class.forName("java.util.jar.JarFile$JarFileEntry").getDeclaredMethod("realName", new Class[0]);
            method.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            method = null;
        }
        REAL_NAME_METHOD = method;
    }
}

