/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.AsyncWriterInterceptor;
import org.jboss.resteasy.spi.AsyncWriterInterceptorContext;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.tracing.InterceptorTimestampPair;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

public abstract class AbstractWriterInterceptorContext
implements WriterInterceptorContext,
AsyncWriterInterceptorContext {
    protected RESTEasyTracingLogger tracingLogger;
    protected WriterInterceptor[] interceptors;
    protected boolean requireAsyncIO;
    protected Object entity;
    protected Class type;
    protected Type genericType;
    protected Annotation[] annotations;
    protected MediaType mediaType;
    protected MultivaluedMap<String, Object> headers;
    protected OutputStream outputStream;
    protected int index = 0;
    protected ResteasyProviderFactory providerFactory;
    private InterceptorTimestampPair<?> lastTracedInterceptor;

    public int getProcessedInterceptorCount() {
        return this.index;
    }

    @Deprecated
    public AbstractWriterInterceptorContext(WriterInterceptor[] interceptors, Annotation[] annotations, Object entity, Type genericType, MediaType mediaType, Class type, OutputStream outputStream, ResteasyProviderFactory providerFactory, MultivaluedMap<String, Object> headers) {
        this.providerFactory = providerFactory;
        this.interceptors = interceptors;
        this.annotations = annotations;
        this.entity = entity;
        this.genericType = genericType;
        this.mediaType = mediaType;
        this.type = type;
        this.outputStream = outputStream;
        this.headers = headers;
        this.tracingLogger = RESTEasyTracingLogger.empty();
    }

    public AbstractWriterInterceptorContext(WriterInterceptor[] interceptors, Annotation[] annotations, Object entity, Type genericType, MediaType mediaType, Class type, OutputStream outputStream, ResteasyProviderFactory providerFactory, MultivaluedMap<String, Object> headers, RESTEasyTracingLogger logger2) {
        this.providerFactory = providerFactory;
        this.interceptors = interceptors;
        this.annotations = annotations;
        this.entity = entity;
        this.genericType = genericType;
        this.mediaType = mediaType;
        this.type = type;
        this.outputStream = outputStream;
        this.headers = headers;
        this.tracingLogger = logger2;
        if (logger2 == null) {
            this.tracingLogger = RESTEasyTracingLogger.empty();
        }
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            throw new NullPointerException(Messages.MESSAGES.annotationsParamNull());
        }
        this.annotations = annotations;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void setAsyncOutputStream(AsyncOutputStream asyncOutputStream) {
        this.outputStream = asyncOutputStream;
    }

    @Override
    public AsyncOutputStream getAsyncOutputStream() {
        return (AsyncOutputStream)this.outputStream;
    }

    public CompletionStage<Void> getStarted() {
        if (this.outputStream instanceof AsyncOutputStream && this.getWriter() instanceof AsyncMessageBodyWriter && this.interceptorsSupportAsyncIo()) {
            this.requireAsyncIO = true;
            return this.asyncProceed();
        }
        try {
            return this.syncProceed();
        }
        catch (IOException | WebApplicationException e) {
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally(e);
            return ret;
        }
    }

    private boolean interceptorsSupportAsyncIo() {
        for (WriterInterceptor interceptor : this.interceptors) {
            if (interceptor instanceof AsyncWriterInterceptor) continue;
            return false;
        }
        return true;
    }

    protected boolean preferAsyncIo() {
        return false;
    }

    @Override
    public CompletionStage<Void> asyncProceed() {
        LogMessages.LOGGER.debugf("Interceptor Context: %s,  Method : proceed", (Object)this.getClass().getName());
        if (this.interceptors == null || this.index >= this.interceptors.length) {
            AsyncMessageBodyWriter writer = (AsyncMessageBodyWriter)this.getWriter();
            if (writer != null) {
                this.tracingLogger.log("MBW_WRITE_TO", writer.getClass().getName());
                LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
            }
            return this.writeTo(writer);
        }
        LogMessages.LOGGER.debugf("WriterInterceptor: %s", (Object)this.interceptors[this.index].getClass().getName());
        int x = this.index;
        this.traceBefore(this.interceptors[x]);
        return ((AsyncWriterInterceptor)this.interceptors[this.index++]).asyncAroundWriteTo(this).whenComplete((v, t) -> this.traceAfter(this.interceptors[x]));
    }

    @Override
    public void proceed() throws IOException, WebApplicationException {
        try {
            this.syncProceed().toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            SynchronousDispatcher.rethrow(e);
        }
        catch (ExecutionException e) {
            SynchronousDispatcher.rethrow(e.getCause());
        }
    }

    public CompletionStage<Void> syncProceed() throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor Context: %s,  Method : proceed", (Object)this.getClass().getName());
        if (this.interceptors == null || this.index >= this.interceptors.length) {
            MessageBodyWriter writer = this.getWriter();
            if (writer != null) {
                this.tracingLogger.log("MBW_WRITE_TO", writer.getClass().getName());
                LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
            }
            return this.writeTo(writer);
        }
        LogMessages.LOGGER.debugf("WriterInterceptor: %s", (Object)this.interceptors[this.index].getClass().getName());
        int x = this.index;
        this.traceBefore(this.interceptors[x]);
        try {
            this.interceptors[this.index++].aroundWriteTo(this);
        }
        finally {
            this.traceAfter(this.interceptors[x]);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected final void traceBefore(WriterInterceptor interceptor) {
        if (this.tracingLogger.isLogEnabled("WI_BEFORE")) {
            if (this.lastTracedInterceptor != null && interceptor != null) {
                this.tracingLogger.logDuration("WI_BEFORE", this.lastTracedInterceptor.getTimestamp(), this.lastTracedInterceptor.getInterceptor());
            }
            this.lastTracedInterceptor = new InterceptorTimestampPair<WriterInterceptor>(interceptor, System.nanoTime());
        }
    }

    protected final void traceAfter(WriterInterceptor interceptor) {
        if (this.tracingLogger.isLogEnabled("WI_AFTER")) {
            if (this.lastTracedInterceptor != null && this.lastTracedInterceptor.getInterceptor() != null) {
                this.tracingLogger.logDuration("WI_AFTER", this.lastTracedInterceptor.getTimestamp(), interceptor);
            }
            this.lastTracedInterceptor = new InterceptorTimestampPair<WriterInterceptor>(interceptor, System.nanoTime());
        }
    }

    protected CompletionStage<Void> writeTo(MessageBodyWriter writer) throws IOException {
        writer.writeTo(this.entity, this.type, this.genericType, this.annotations, this.mediaType, this.headers, this.outputStream);
        return CompletableFuture.completedFuture(null);
    }

    protected CompletionStage<Void> writeTo(AsyncMessageBodyWriter writer) {
        return writer.asyncWriteTo(this.entity, this.type, this.genericType, this.annotations, this.mediaType, this.headers, (AsyncOutputStream)this.outputStream);
    }

    protected MessageBodyWriter getWriter() {
        MessageBodyWriter writer = this.resolveWriter();
        if (this.requireAsyncIO && !(writer instanceof AsyncMessageBodyWriter)) {
            throw new IllegalStateException("Cannot switch body writer from blocking to asynchronous during writer interceptor run");
        }
        if (writer == null) {
            this.throwWriterNotFoundException();
        }
        return writer;
    }

    protected abstract MessageBodyWriter resolveWriter();

    abstract void throwWriterNotFoundException();
}

