/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class BaseServletConfigSource
implements ConfigSource {
    protected ConfigSource source;
    protected final boolean available;
    protected final int defaultOrdinal;
    private final String name;

    public BaseServletConfigSource(Class<?> sourceClass, int defaultOrdinal) {
        this.defaultOrdinal = defaultOrdinal;
        if (sourceClass != null) {
            try {
                this.source = (ConfigSource)sourceClass.newInstance();
                this.name = this.source.getName();
                this.available = true;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else {
            this.name = this.toString();
            this.available = false;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        if (!this.available) {
            return Collections.emptyMap();
        }
        return this.source.getProperties();
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    @Override
    public int getOrdinal() {
        if (!this.available) {
            return this.defaultOrdinal;
        }
        return this.source.getOrdinal();
    }

    @Override
    public String getValue(String propertyName) {
        if (!this.available) {
            return null;
        }
        return this.source.getValue(propertyName);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

