/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.model.job;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.kie.kogito.jobs.service.executor.HttpJobExecutor;
import org.kie.kogito.jobs.service.model.job.HttpJobContext;
import org.kie.kogito.timer.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpJob
implements Job<HttpJobContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpJob.class);
    private Optional<HttpJobExecutor> executor;

    public HttpJob(HttpJobExecutor executor) {
        this.executor = Optional.ofNullable(executor);
    }

    public HttpJob() {
        this.executor = Optional.ofNullable(Arc.container()).map(c -> c.instance(HttpJobExecutor.class, new Annotation[0])).map(InstanceHandle::get);
    }

    @Override
    public void execute(HttpJobContext ctx) {
        LOGGER.info("Executing for context {}", (Object)ctx.getJobDetails());
        this.executor.ifPresent(e -> e.execute(CompletableFuture.completedFuture(ctx.getJobDetails())).thenAccept(j -> LOGGER.debug("Executed {}", j)));
    }
}

