/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan;

import io.quarkus.runtime.StartupEvent;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Readiness;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.kie.kogito.infinispan.health.InfinispanHealthCheck;
import org.kie.kogito.jobs.service.repository.infinispan.InfinispanInitialized;

@ApplicationScoped
public class InfinispanConfiguration {
    public static final String CACHE_TEMPLATE_XML = "META-INF/kogito-cache-default.xml";
    private AtomicBoolean initialized = new AtomicBoolean(Boolean.FALSE);

    @Produces
    @Readiness
    public HealthCheck infinispanHealthCheck(Instance<RemoteCacheManager> cacheManagerInstance) {
        return new InfinispanHealthCheck(cacheManagerInstance);
    }

    void initializeCaches(@Observes @Priority(value=0) StartupEvent startupEvent, Instance<RemoteCacheManager> remoteCacheManager, Event<InfinispanInitialized> initializedEvent) {
        Optional.ofNullable(((RemoteCacheManager)remoteCacheManager.get()).getCache("JOB_DETAILS")).ifPresent(c -> {
            initializedEvent.fire(new InfinispanInitialized());
            this.initialized.set(Boolean.TRUE);
        });
    }

    protected Boolean isInitialized() {
        return this.initialized.get();
    }

    public static class Caches {
        public static final String JOB_DETAILS = "JOB_DETAILS";

        private Caches() {
        }
    }
}

