/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;

public class KiePMMLOutputField
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = 2408750585433339543L;
    private RESULT_FEATURE resultFeature = RESULT_FEATURE.PREDICTED_VALUE;
    private String targetField = null;
    private Integer rank;
    private Object value;
    private KiePMMLExpression kiePMMLExpression;

    private KiePMMLOutputField(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions) {
        return new Builder(name, extensions);
    }

    public RESULT_FEATURE getResultFeature() {
        return this.resultFeature;
    }

    public Optional<String> getTargetField() {
        return Optional.ofNullable(this.targetField);
    }

    public Object getValue() {
        return this.value;
    }

    public Integer getRank() {
        return this.rank;
    }

    public KiePMMLExpression getKiePMMLExpression() {
        return this.kiePMMLExpression;
    }

    public Object evaluate(List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, List<KiePMMLNameValue> kiePMMLNameValues) {
        return this.kiePMMLExpression != null ? this.kiePMMLExpression.evaluate(defineFunctions, derivedFields, outputFields, kiePMMLNameValues) : null;
    }

    public String toString() {
        return new StringJoiner(", ", KiePMMLOutputField.class.getSimpleName() + "[", "]").add("resultFeature=" + (Object)((Object)this.resultFeature)).add("targetField='" + this.targetField + "'").add("rank=" + this.rank).add("value=" + this.value).add("name='" + this.name + "'").add("kiePMMLExpression='" + this.kiePMMLExpression + "'").add("extensions=" + this.extensions).add("id='" + this.id + "'").add("parentId='" + this.parentId + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KiePMMLOutputField that = (KiePMMLOutputField)o;
        return this.resultFeature == that.resultFeature && Objects.equals(this.targetField, that.targetField) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.resultFeature, this.targetField, this.value});
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLOutputField> {
        private Builder(String name, List<KiePMMLExtension> extensions) {
            super("OutputField-", () -> new KiePMMLOutputField(name, extensions));
        }

        public Builder withResultFeature(RESULT_FEATURE resultFeature) {
            if (resultFeature != null) {
                ((KiePMMLOutputField)this.toBuild).resultFeature = resultFeature;
            }
            return this;
        }

        public Builder withTargetField(String targetField) {
            if (targetField != null) {
                ((KiePMMLOutputField)this.toBuild).targetField = targetField;
            }
            return this;
        }

        public Builder withValue(Object value) {
            ((KiePMMLOutputField)this.toBuild).value = value;
            return this;
        }

        public Builder withRank(Integer rank) {
            if (rank != null) {
                ((KiePMMLOutputField)this.toBuild).rank = rank;
            }
            return this;
        }

        public Builder withKiePMMLExpression(KiePMMLExpression kiePMMLExpression) {
            if (kiePMMLExpression != null) {
                ((KiePMMLOutputField)this.toBuild).kiePMMLExpression = kiePMMLExpression;
            }
            return this;
        }
    }
}

