/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan;

import io.quarkus.runtime.StartupEvent;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Readiness;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.kie.kogito.infinispan.health.InfinispanHealthCheck;
import org.kie.kogito.jobs.service.repository.infinispan.InfinispanInitialized;

@ApplicationScoped
public class InfinispanConfiguration {
    private AtomicBoolean initialized = new AtomicBoolean(Boolean.FALSE);

    @Produces
    @Readiness
    public HealthCheck infinispanHealthCheck(Instance<RemoteCacheManager> cacheManagerInstance) {
        return new InfinispanHealthCheck(cacheManagerInstance);
    }

    void initializeCaches(@Observes @Priority(value=0) StartupEvent startupEvent, Instance<RemoteCacheManager> remoteCacheManager, Event<InfinispanInitialized> initializedEvent) {
        Optional.ofNullable(((RemoteCacheManager)remoteCacheManager.get()).getCache("JOB_DETAILS_V2")).ifPresent(c -> {
            initializedEvent.fire((Object)new InfinispanInitialized());
            this.initialized.set(Boolean.TRUE);
        });
    }

    protected Boolean isInitialized() {
        return this.initialized.get();
    }

    public static class Caches {
        public static final String JOB_DETAILS = "JOB_DETAILS_V2";

        private Caches() {
        }
    }
}

