/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.messaging.http;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.quarkus.reactivemessaging.http.runtime.IncomingHttpMetadata;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.service.TestUtils;
import org.kie.kogito.jobs.service.messaging.http.CloudEventConverter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CloudEventConverterTest {
    private static final String STRUCTURED_CLOUD_EVENT = "org/kie/kogito/jobs/service/messaging/http/StructuredCloudEvent.json";
    private static final String BINARY_CLOUD_EVENT_DATA = "org/kie/kogito/jobs/service/messaging/http/BinaryCloudEventData.json";
    private static final String EVENT_ID = "ID";
    private static final URI EVENT_SOURCE = URI.create("http://my_event_source");
    private static final String EVENT_TYPE = "TYPE";
    private static final OffsetDateTime EVENT_TIME = OffsetDateTime.parse("2022-07-27T15:01:20.001+01:00");
    private static final URI EVENT_DATA_SCHEMA = URI.create("http://my_event_data_schema/my_schema.json");
    private static final String EVENT_DATA_CONTENT_TYPE = "application/json; charset=utf-8";
    private static final String EVENT_SUBJECT = "SUBJECT";
    private static final String EXTENSION1_NAME = "extension1";
    private static final String EXTENSION1_VALUE = "EXTENSION_1";
    private static final String EXTENSION2_NAME = "extension2";
    private static final String EXTENSION2_VALUE = "EXTENSION_2";
    private static final String DATA_FIELD1 = "dataField1";
    private static final String DATA_FIELD1_VALUE = "DATA_FIELD_1";
    private static final String DATA_FIELD2 = "dataField2";
    private static final String DATA_FIELD2_VALUE = "DATA_FIELD_2";
    @Mock
    IncomingHttpMetadata httpMetadata;
    private MultiMap headers;
    private CloudEventConverter converter;

    CloudEventConverterTest() {
    }

    @BeforeEach
    void setUp() {
        this.headers = MultiMap.caseInsensitiveMultiMap();
        ((IncomingHttpMetadata)Mockito.lenient().doReturn((Object)this.headers).when((Object)this.httpMetadata)).getHeaders();
        this.converter = new CloudEventConverter();
    }

    @Test
    void canConvertHttpMetadataIsPresent() {
        Buffer buffer = Buffer.buffer((String)"{}");
        Message message = Message.of((Object)buffer, (Metadata)Metadata.of((Object[])new Object[]{this.httpMetadata}));
        Assertions.assertThat((boolean)this.converter.canConvert(message, CloudEvent.class)).isTrue();
    }

    @Test
    void canConvertHttpMetadataIsNotPresent() {
        Buffer buffer = Buffer.buffer((String)"{}");
        Message message = Message.of((Object)buffer);
        Assertions.assertThat((boolean)this.converter.canConvert(message, CloudEvent.class)).isFalse();
    }

    @Test
    void convertStructuredCloudEvent() throws Exception {
        this.headers.add("Content-Type", "application/cloudevents+json");
        this.convert(STRUCTURED_CLOUD_EVENT);
    }

    @Test
    void convertBinaryCloudEvent() throws Exception {
        this.headers.add(CloudEventConverterTest.ceHeader("specversion"), SpecVersion.V1.toString());
        this.headers.add(CloudEventConverterTest.ceHeader("id"), EVENT_ID);
        this.headers.add(CloudEventConverterTest.ceHeader("source"), EVENT_SOURCE.toString());
        this.headers.add(CloudEventConverterTest.ceHeader("type"), EVENT_TYPE);
        this.headers.add(CloudEventConverterTest.ceHeader("time"), EVENT_TIME.toString());
        this.headers.add(CloudEventConverterTest.ceHeader("dataschema"), EVENT_DATA_SCHEMA.toString());
        this.headers.add(CloudEventConverterTest.ceHeader("datacontenttype"), EVENT_DATA_CONTENT_TYPE);
        this.headers.add(CloudEventConverterTest.ceHeader("subject"), EVENT_SUBJECT);
        this.headers.add(CloudEventConverterTest.ceHeader(EXTENSION1_NAME), EXTENSION1_VALUE);
        this.headers.add(CloudEventConverterTest.ceHeader(EXTENSION2_NAME), EXTENSION2_VALUE);
        this.convert(BINARY_CLOUD_EVENT_DATA);
    }

    private void convert(String bufferContentResource) throws Exception {
        Buffer buffer = Buffer.buffer((byte[])TestUtils.readFileContent((String)bufferContentResource));
        Message message = Message.of((Object)buffer, (Metadata)Metadata.of((Object[])new Object[]{this.httpMetadata}));
        Message result = this.converter.convert(message, CloudEvent.class);
        Assertions.assertThat((Object)result.getPayload()).isInstanceOf(CloudEvent.class);
        CloudEvent cloudEvent = (CloudEvent)result.getPayload();
        this.assertSpecFields(cloudEvent);
        this.assertExtensionFields(cloudEvent);
        this.assertData(cloudEvent);
    }

    private void assertSpecFields(CloudEvent cloudEvent) {
        Assertions.assertThat((Comparable)cloudEvent.getSpecVersion()).isEqualTo((Object)SpecVersion.V1);
        Assertions.assertThat((String)cloudEvent.getId()).isEqualTo(EVENT_ID);
        Assertions.assertThat((URI)cloudEvent.getSource()).isEqualTo((Object)EVENT_SOURCE);
        Assertions.assertThat((String)cloudEvent.getType()).isEqualTo(EVENT_TYPE);
        Assertions.assertThat((OffsetDateTime)cloudEvent.getTime()).isEqualTo((Object)EVENT_TIME);
        Assertions.assertThat((URI)cloudEvent.getDataSchema()).isEqualTo((Object)EVENT_DATA_SCHEMA);
        Assertions.assertThat((String)cloudEvent.getDataContentType()).isEqualTo(EVENT_DATA_CONTENT_TYPE);
        Assertions.assertThat((String)cloudEvent.getSubject()).isEqualTo(EVENT_SUBJECT);
    }

    private void assertExtensionFields(CloudEvent cloudEvent) {
        Assertions.assertThat((Collection)cloudEvent.getExtensionNames()).containsExactlyInAnyOrder((Object[])new String[]{EXTENSION1_NAME, EXTENSION2_NAME});
        Assertions.assertThat((Object)cloudEvent.getExtension(EXTENSION1_NAME)).isEqualTo((Object)EXTENSION1_VALUE);
        Assertions.assertThat((Object)cloudEvent.getExtension(EXTENSION2_NAME)).isEqualTo((Object)EXTENSION2_VALUE);
    }

    private void assertData(CloudEvent cloudEvent) {
        Assertions.assertThat((Object)cloudEvent.getData()).isNotNull();
        JsonObject dataObject = new JsonObject(Buffer.buffer((byte[])cloudEvent.getData().toBytes()));
        Assertions.assertThat((Iterable)dataObject).isNotNull();
        Assertions.assertThat((Collection)dataObject.fieldNames()).containsExactlyInAnyOrder((Object[])new String[]{DATA_FIELD1, DATA_FIELD2});
        Assertions.assertThat((Object)dataObject.getValue(DATA_FIELD1)).isEqualTo((Object)DATA_FIELD1_VALUE);
        Assertions.assertThat((Object)dataObject.getValue(DATA_FIELD2)).isEqualTo((Object)DATA_FIELD2_VALUE);
    }

    private static String ceHeader(String name) {
        return "ce-" + name;
    }
}

