/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.messaging.http.health.knative;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.function.UnaryOperator;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Liveness
@ApplicationScoped
public class KSinkInjectionHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(KSinkInjectionHealthCheck.class);
    public static final String K_SINK = "K_SINK";
    private final UnaryOperator<String> envReader;

    public KSinkInjectionHealthCheck() {
        this(System::getenv);
    }

    KSinkInjectionHealthCheck(UnaryOperator<String> envReader) {
        this.envReader = envReader;
    }

    public HealthCheckResponse call() {
        Object reason;
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)"K_SINK environment variable injection check");
        String sinkURL = (String)this.envReader.apply(K_SINK);
        Exception cause = null;
        if (sinkURL == null || sinkURL.isEmpty()) {
            reason = "K_SINK variable not set in this environment";
            LOGGER.warn("{}. Returning not healthy.", reason);
        } else {
            try {
                URI uri = new URI(sinkURL);
                InetAddress address = InetAddress.getByName(uri.getHost());
                if (address != null) {
                    responseBuilder.up();
                    return responseBuilder.build();
                }
                reason = "Impossible to resolve host: " + uri.getHost() + " for URL: " + sinkURL;
                LOGGER.warn("{}. Check if this host can be resolved from this environment. Returning not healthy.", reason);
            }
            catch (UnknownHostException e) {
                reason = "Failed to lookup address: " + sinkURL;
                cause = e;
                LOGGER.warn("{}. Returning not healthy.", reason);
            }
            catch (URISyntaxException e) {
                reason = "The K_SINK URL syntax is invalid: " + sinkURL;
                cause = e;
                LOGGER.warn((String)reason + ". Returning not healthy.", (Throwable)e);
            }
        }
        return responseBuilder.withData("reason", KSinkInjectionHealthCheck.buildMessage((String)reason, cause)).down().build();
    }

    private static String buildMessage(String reason, Exception cause) {
        if (cause != null) {
            return reason + ". " + cause.getMessage();
        }
        return reason + ".";
    }
}

