/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.messaging.http.stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.reactivemessaging.http.runtime.OutgoingHttpMetadata;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.stream.AbstractJobStreams;

@ApplicationScoped
public class HttpJobStreams
extends AbstractJobStreams {
    public static final String PUBLISH_EVENTS_CONFIG_KEY = "kogito.jobs-service.http.job-status-change-events";
    public static final String JOB_STATUS_CHANGE_EVENTS_HTTP = "kogito-job-service-job-status-events-http";
    public static final Supplier<OutgoingHttpMetadata> OUTGOING_HTTP_METADATA = () -> new OutgoingHttpMetadata.Builder().addHeader("Content-Type", "application/cloudevents+json").build();

    @Inject
    public HttpJobStreams(ObjectMapper objectMapper, @ConfigProperty(name="kogito.jobs-service.http.job-status-change-events") Optional<Boolean> config, @Channel(value="kogito-job-service-job-status-events-http") @OnOverflow(value=OnOverflow.Strategy.LATEST) Emitter<String> emitter, @ConfigProperty(name="kogito.service.url", defaultValue="http://localhost:8080") String url) {
        super(objectMapper, config.orElse(false).booleanValue(), emitter, url);
    }

    @Incoming(value="job-status-change-events")
    @Acknowledgment(value=Acknowledgment.Strategy.PRE_PROCESSING)
    public void jobStatusChange(JobDetails job) {
        super.jobStatusChange(job);
    }

    protected Message<String> decorate(Message<String> message) {
        return message.addMetadata((Object)OUTGOING_HTTP_METADATA.get());
    }
}

