/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.postgresql;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiOnItem;
import io.smallrye.mutiny.groups.UniConvert;
import io.smallrye.mutiny.groups.UniOnItem;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.pgclient.PgPool;
import io.vertx.mutiny.sqlclient.PreparedQuery;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowSet;
import io.vertx.mutiny.sqlclient.Tuple;
import java.time.ZonedDateTime;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.jobs.service.repository.marshaller.RecipientMarshaller;
import org.kie.kogito.jobs.service.repository.marshaller.TriggerMarshaller;
import org.kie.kogito.jobs.service.repository.postgresql.PostgreSqlJobRepository;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PostgreSqlJobRepositoryTest {
    PostgreSqlJobRepository repository;
    PgPool client;
    PreparedQuery<RowSet<Row>> query;
    CompletableFuture completableFuture;
    ZonedDateTime time;

    PostgreSqlJobRepositoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.time = ZonedDateTime.now(DateUtil.DEFAULT_ZONE);
        this.client = (PgPool)Mockito.mock(PgPool.class);
        this.query = (PreparedQuery)Mockito.mock(PreparedQuery.class);
        Mockito.when((Object)this.client.preparedQuery(ArgumentMatchers.anyString())).thenReturn(this.query);
        Mockito.when((Object)this.client.query(ArgumentMatchers.anyString())).thenReturn(this.query);
        Uni uni = (Uni)Mockito.mock(Uni.class);
        Mockito.when((Object)this.query.execute((Tuple)ArgumentMatchers.any(Tuple.class))).thenReturn((Object)uni);
        Mockito.when((Object)this.query.execute()).thenReturn((Object)uni);
        UniOnItem uniOnItem = (UniOnItem)Mockito.mock(UniOnItem.class);
        Mockito.when((Object)uni.onItem()).thenReturn((Object)uniOnItem);
        Mockito.when((Object)uniOnItem.transform((Function)ArgumentMatchers.any(Function.class))).thenReturn((Object)uni);
        Mockito.when((Object)uni.emitOn((Executor)ArgumentMatchers.any(Executor.class))).thenReturn((Object)uni);
        Multi multi = (Multi)Mockito.mock(Multi.class);
        Mockito.when((Object)uniOnItem.transformToMulti((Function)ArgumentMatchers.any(Function.class))).thenReturn((Object)multi);
        MultiOnItem multiOnItem = (MultiOnItem)Mockito.mock(MultiOnItem.class);
        Mockito.when((Object)multi.onItem()).thenReturn((Object)multiOnItem);
        Mockito.when((Object)multiOnItem.transform((Function)ArgumentMatchers.any(Function.class))).thenReturn((Object)multi);
        Mockito.when((Object)multi.emitOn((Executor)ArgumentMatchers.any(Executor.class))).thenReturn((Object)multi);
        this.completableFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        UniConvert convert = (UniConvert)Mockito.mock(UniConvert.class);
        Mockito.when((Object)uni.convert()).thenReturn((Object)convert);
        Mockito.when((Object)convert.toCompletableFuture()).thenReturn((Object)this.completableFuture);
        TriggerMarshaller triggerMarshaller = (TriggerMarshaller)Mockito.mock(TriggerMarshaller.class);
        Mockito.when((Object)triggerMarshaller.marshall((Trigger)ArgumentMatchers.any(Trigger.class))).thenReturn((Object)new JsonObject().put("triggerMarshaller", (Object)"test"));
        Mockito.when((Object)triggerMarshaller.unmarshall((JsonObject)ArgumentMatchers.any(JsonObject.class))).thenReturn((Object)new PointInTimeTrigger(this.time.toInstant().getEpochSecond(), null, null));
        RecipientMarshaller recipientMarshaller = (RecipientMarshaller)Mockito.mock(RecipientMarshaller.class);
        Mockito.when((Object)recipientMarshaller.marshall((Recipient)ArgumentMatchers.any(Recipient.class))).thenReturn((Object)new JsonObject().put("recipientMarshaller", (Object)"test"));
        Mockito.when((Object)recipientMarshaller.unmarshall((JsonObject)ArgumentMatchers.any(JsonObject.class))).thenReturn((Object)new Recipient.HTTPRecipient("test"));
        this.repository = new PostgreSqlJobRepository(null, null, this.client, triggerMarshaller, recipientMarshaller);
    }

    @Test
    void doSave() {
        PointInTimeTrigger trigger = new PointInTimeTrigger(this.time.toInstant().getEpochSecond(), null, null);
        Recipient.HTTPRecipient recipient = new Recipient.HTTPRecipient("test");
        JobDetails job = JobDetails.builder().id("test").correlationId("test").status(JobStatus.SCHEDULED).lastUpdate(this.time).retries(Integer.valueOf(1)).executionCounter(Integer.valueOf(1)).scheduledId("test").payload((Object)"{\"payload\": \"test\"}").type(JobDetails.Type.HTTP).priority(Integer.valueOf(1)).recipient((Recipient)recipient).trigger((Trigger)trigger).build();
        CompletionStage result = this.repository.doSave(job);
        Assertions.assertEquals((Object)this.completableFuture, (Object)result);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor parameterCaptor = ArgumentCaptor.forClass(Tuple.class);
        ((PgPool)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).preparedQuery((String)queryCaptor.capture());
        ((PreparedQuery)Mockito.verify(this.query, (VerificationMode)Mockito.times((int)1))).execute((Tuple)parameterCaptor.capture());
        String query = "INSERT INTO job_details (id, correlation_id, status, last_update, retries, execution_counter, scheduled_id, payload, type, priority, recipient, trigger, fire_time) VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13) ON CONFLICT (id) DO UPDATE SET correlation_id = $2, status = $3, last_update = $4, retries = $5, execution_counter = $6, scheduled_id = $7, payload = $8, type = $9, priority = $10, recipient = $11, trigger = $12, fire_time = $13 RETURNING id, correlation_id, status, last_update, retries, execution_counter, scheduled_id, payload, type, priority, recipient, trigger, fire_time";
        Tuple parameter = Tuple.tuple(Stream.of(job.getId(), job.getCorrelationId(), job.getStatus().name(), job.getLastUpdate().toOffsetDateTime(), job.getRetries(), job.getExecutionCounter(), job.getScheduledId(), new JsonObject(job.getPayload().toString()), job.getType().name(), job.getPriority(), new JsonObject().put("recipientMarshaller", (Object)"test"), new JsonObject().put("triggerMarshaller", (Object)"test")).collect(Collectors.toList()));
        Assertions.assertEquals((Object)query, (Object)queryCaptor.getValue());
        Assertions.assertEquals((Object)parameter.getString(0), (Object)((Tuple)parameterCaptor.getValue()).getString(0));
        Assertions.assertEquals((Object)parameter.getString(1), (Object)((Tuple)parameterCaptor.getValue()).getString(1));
        Assertions.assertEquals((Object)parameter.getString(2), (Object)((Tuple)parameterCaptor.getValue()).getString(2));
        Assertions.assertEquals((Object)parameter.getOffsetDateTime(3), (Object)((Tuple)parameterCaptor.getValue()).getOffsetDateTime(3));
        Assertions.assertEquals((Integer)parameter.getInteger(4), (Integer)((Tuple)parameterCaptor.getValue()).getInteger(4));
        Assertions.assertEquals((Integer)parameter.getInteger(5), (Integer)((Tuple)parameterCaptor.getValue()).getInteger(5));
        Assertions.assertEquals((Object)parameter.getString(6), (Object)((Tuple)parameterCaptor.getValue()).getString(6));
        Assertions.assertEquals((Object)parameter.getJson(7), (Object)((Tuple)parameterCaptor.getValue()).getJson(7));
        Assertions.assertEquals((Object)parameter.getString(8), (Object)((Tuple)parameterCaptor.getValue()).getString(8));
        Assertions.assertEquals((Integer)parameter.getInteger(9), (Integer)((Tuple)parameterCaptor.getValue()).getInteger(9));
        Assertions.assertEquals((Object)parameter.getJson(10), (Object)((Tuple)parameterCaptor.getValue()).getJson(10));
        Assertions.assertEquals((Object)parameter.getJson(11), (Object)((Tuple)parameterCaptor.getValue()).getJson(11));
    }

    @Test
    void get() {
        CompletionStage result = this.repository.get("test");
        Assertions.assertEquals((Object)this.completableFuture, (Object)result);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor parameterCaptor = ArgumentCaptor.forClass(Tuple.class);
        ((PgPool)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).preparedQuery((String)queryCaptor.capture());
        ((PreparedQuery)Mockito.verify(this.query, (VerificationMode)Mockito.times((int)1))).execute((Tuple)parameterCaptor.capture());
        String query = "SELECT id, correlation_id, status, last_update, retries, execution_counter, scheduled_id, payload, type, priority, recipient, trigger, fire_time FROM job_details WHERE id = $1";
        String parameter = "test";
        Assertions.assertEquals((Object)query, (Object)queryCaptor.getValue());
        Assertions.assertEquals((Object)parameter, (Object)((Tuple)parameterCaptor.getValue()).getValue(0));
    }

    @Test
    void exists() {
        CompletionStage result = this.repository.exists("test");
        Assertions.assertEquals((Object)this.completableFuture, (Object)result);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor parameterCaptor = ArgumentCaptor.forClass(Tuple.class);
        ((PgPool)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).preparedQuery((String)queryCaptor.capture());
        ((PreparedQuery)Mockito.verify(this.query, (VerificationMode)Mockito.times((int)1))).execute((Tuple)parameterCaptor.capture());
        String query = "SELECT id FROM job_details WHERE id = $1";
        String parameter = "test";
        Assertions.assertEquals((Object)query, (Object)queryCaptor.getValue());
        Assertions.assertEquals((Object)parameter, (Object)((Tuple)parameterCaptor.getValue()).getValue(0));
    }

    @Test
    void delete() {
        CompletionStage result = this.repository.delete("test");
        Assertions.assertEquals((Object)this.completableFuture, (Object)result);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor parameterCaptor = ArgumentCaptor.forClass(Tuple.class);
        ((PgPool)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).preparedQuery((String)queryCaptor.capture());
        ((PreparedQuery)Mockito.verify(this.query, (VerificationMode)Mockito.times((int)1))).execute((Tuple)parameterCaptor.capture());
        String query = "DELETE FROM job_details WHERE id = $1 RETURNING id, correlation_id, status, last_update, retries, execution_counter, scheduled_id, payload, type, priority, recipient, trigger, fire_time";
        String parameter = "test";
        Assertions.assertEquals((Object)query, (Object)queryCaptor.getValue());
        Assertions.assertEquals((Object)parameter, (Object)((Tuple)parameterCaptor.getValue()).getValue(0));
    }

    @Test
    void findAll() {
        PublisherBuilder result = this.repository.findAll();
        Assertions.assertNotNull((Object)result);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(String.class);
        ((PgPool)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).preparedQuery((String)queryCaptor.capture());
        String query = "SELECT id, correlation_id, status, last_update, retries, execution_counter, scheduled_id, payload, type, priority, recipient, trigger, fire_time FROM job_details LIMIT $1";
        Assertions.assertEquals((Object)query, (Object)queryCaptor.getValue());
    }

    @Test
    void findByStatusBetweenDatesOrderByPriority() {
        ZonedDateTime from = ZonedDateTime.now();
        ZonedDateTime to = ZonedDateTime.now();
        PublisherBuilder result = this.repository.findByStatusBetweenDatesOrderByPriority(from, to, new JobStatus[]{JobStatus.SCHEDULED, JobStatus.RETRY});
        Assertions.assertNotNull((Object)result);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(String.class);
        ((PgPool)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).preparedQuery((String)queryCaptor.capture());
        String query = "SELECT id, correlation_id, status, last_update, retries, execution_counter, scheduled_id, payload, type, priority, recipient, trigger, fire_time FROM job_details WHERE status IN ('SCHEDULED', 'RETRY') AND fire_time BETWEEN $2 AND $3 ORDER BY priority DESC LIMIT $1";
        Assertions.assertEquals((Object)query, (Object)queryCaptor.getValue());
    }

    @Test
    void findByStatusBetweenDatesOrderByPriorityNoCondition() {
        ZonedDateTime from = ZonedDateTime.now();
        ZonedDateTime to = ZonedDateTime.now();
        PublisherBuilder result = this.repository.findByStatusBetweenDatesOrderByPriority(from, to, new JobStatus[]{JobStatus.SCHEDULED});
        Assertions.assertNotNull((Object)result);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(String.class);
        ((PgPool)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).preparedQuery((String)queryCaptor.capture());
        String query = "SELECT id, correlation_id, status, last_update, retries, execution_counter, scheduled_id, payload, type, priority, recipient, trigger, fire_time FROM job_details WHERE status IN ('SCHEDULED') AND fire_time BETWEEN $2 AND $3 ORDER BY priority DESC LIMIT $1";
        Assertions.assertEquals((Object)query, (Object)queryCaptor.getValue());
    }

    @Test
    void createStatusQuery() {
        String statusQuery = PostgreSqlJobRepository.createStatusQuery((JobStatus[])new JobStatus[]{JobStatus.SCHEDULED, JobStatus.RETRY});
        Assertions.assertEquals((Object)"status IN ('SCHEDULED', 'RETRY')", (Object)statusQuery);
    }

    @Test
    void createTimeQuery() {
        String timeQuery = PostgreSqlJobRepository.createTimeQuery((String)"$1", (String)"$2");
        Assertions.assertEquals((Object)"fire_time BETWEEN $1 AND $2", (Object)timeQuery);
    }

    @Test
    void from() {
        PointInTimeTrigger trigger = new PointInTimeTrigger(this.time.toInstant().getEpochSecond(), null, null);
        Recipient.HTTPRecipient recipient = new Recipient.HTTPRecipient("test");
        Row row = (Row)Mockito.mock(Row.class);
        Mockito.when((Object)row.getString("id")).thenReturn((Object)"test");
        Mockito.when((Object)row.getString("correlation_id")).thenReturn((Object)"test");
        Mockito.when((Object)row.getString("status")).thenReturn((Object)"SCHEDULED");
        Mockito.when((Object)row.getOffsetDateTime("last_update")).thenReturn((Object)this.time.toOffsetDateTime());
        Mockito.when((Object)row.getInteger("retries")).thenReturn((Object)1);
        Mockito.when((Object)row.getInteger("execution_counter")).thenReturn((Object)1);
        Mockito.when((Object)row.getString("scheduled_id")).thenReturn((Object)"test");
        Mockito.when((Object)((JsonObject)row.get(JsonObject.class, 7))).thenReturn((Object)new JsonObject("{\"payload\": \"test\"}"));
        Mockito.when((Object)row.getString("type")).thenReturn((Object)"HTTP");
        Mockito.when((Object)row.getInteger("priority")).thenReturn((Object)1);
        Mockito.when((Object)((JsonObject)row.get(JsonObject.class, 10))).thenReturn((Object)new JsonObject().put("recipientMarshaller", (Object)"test"));
        Mockito.when((Object)((JsonObject)row.get(JsonObject.class, 11))).thenReturn((Object)new JsonObject().put("triggerMarshaller", (Object)"test"));
        JobDetails jobDetails = this.repository.from(row);
        JobDetails expected = JobDetails.builder().id("test").correlationId("test").status(JobStatus.SCHEDULED).lastUpdate(this.time).retries(Integer.valueOf(1)).executionCounter(Integer.valueOf(1)).scheduledId("test").payload((Object)"{\"payload\": \"test\"}").type(JobDetails.Type.HTTP).priority(Integer.valueOf(1)).recipient((Recipient)recipient).trigger((Trigger)trigger).build();
        Assertions.assertEquals((Object)expected, (Object)jobDetails);
    }
}

