/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan.marshaller;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.JobBuilder;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.repository.infinispan.marshaller.BaseMarshaller;
import org.kie.kogito.jobs.service.utils.DateUtil;

public class ScheduledJobMarshaller
extends BaseMarshaller<ScheduledJob> {
    public String getTypeName() {
        return this.getPackage() + ".ScheduledJob";
    }

    public Class<? extends ScheduledJob> getJavaClass() {
        return ScheduledJob.class;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, ScheduledJob job) throws IOException {
        writer.writeString("id", job.getId());
        writer.writeString("callbackEndpoint", job.getCallbackEndpoint());
        writer.writeInstant("expirationTime", DateUtil.zonedDateTimeToInstant(job.getExpirationTime()));
        writer.writeInt("priority", job.getPriority());
        writer.writeString("processId", job.getProcessId());
        writer.writeString("processInstanceId", job.getProcessInstanceId());
        writer.writeString("rootProcessId", job.getRootProcessId());
        writer.writeString("rootProcessInstanceId", job.getRootProcessInstanceId());
        writer.writeLong("repeatInterval", job.getRepeatInterval());
        writer.writeInt("repeatLimit", job.getRepeatLimit());
        writer.writeString("scheduledId", job.getScheduledId());
        writer.writeInt("retries", job.getRetries());
        writer.writeString("status", Optional.ofNullable(job.getStatus()).map(Enum::name).orElse(""));
        writer.writeInstant("lastUpdate", DateUtil.zonedDateTimeToInstant(job.getLastUpdate()));
        writer.writeInt("executionCounter", job.getExecutionCounter());
    }

    public ScheduledJob readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        String id = reader.readString("id");
        String callbackEndpoint = reader.readString("callbackEndpoint");
        ZonedDateTime expirationTime = DateUtil.instantToZonedDateTime(reader.readInstant("expirationTime"));
        Integer priority = reader.readInt("priority");
        String processId = reader.readString("processId");
        String processInstanceId = reader.readString("processInstanceId");
        String rootProcessId = reader.readString("rootProcessId");
        String rootProcessInstanceId = reader.readString("rootProcessInstanceId");
        Long repeatInterval = reader.readLong("repeatInterval");
        Integer repeatLimit = reader.readInt("repeatLimit");
        Job job = JobBuilder.builder().callbackEndpoint(callbackEndpoint).id(id).expirationTime(expirationTime).priority(priority).processId(processId).processInstanceId(processInstanceId).rootProcessId(rootProcessId).rootProcessInstanceId(rootProcessInstanceId).repeatInterval(repeatInterval).repeatLimit(repeatLimit).build();
        String scheduledId = reader.readString("scheduledId");
        Integer retries = reader.readInt("retries");
        JobStatus status = Optional.ofNullable(reader.readString("status")).filter(StringUtils::isNotBlank).map(JobStatus::valueOf).orElse(null);
        ZonedDateTime lastUpdate = DateUtil.instantToZonedDateTime(reader.readInstant("lastUpdate"));
        Integer executionCounter = reader.readInt("executionCounter");
        return ScheduledJob.builder().job(job).scheduledId(scheduledId).retries(retries).status(status).job(job).lastUpdate(lastUpdate).executionCounter(executionCounter).build();
    }
}

