/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.model;

import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.service.model.JobExecutionResponse;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.utils.DateUtil;

public class ScheduledJob
extends Job {
    private String scheduledId;
    private Integer retries;
    private JobStatus status;
    private ZonedDateTime lastUpdate;
    private Integer executionCounter;
    private JobExecutionResponse executionResponse;

    public ScheduledJob() {
    }

    private ScheduledJob(Optional<Job> job, Optional<ZonedDateTime> expirationTime) {
        super((String)job.map(Job::getId).orElse(null), expirationTime.orElse(job.map(Job::getExpirationTime).orElse(null)), (Integer)job.map(Job::getPriority).orElse(null), (String)job.map(Job::getCallbackEndpoint).orElse(null), (String)job.map(Job::getProcessInstanceId).orElse(null), (String)job.map(Job::getRootProcessInstanceId).orElse(null), (String)job.map(Job::getProcessId).orElse(null), (String)job.map(Job::getRootProcessId).orElse(null), (Long)job.map(Job::getRepeatInterval).orElse(null), (Integer)job.map(Job::getRepeatLimit).orElse(null));
    }

    public String getScheduledId() {
        return this.scheduledId;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public ZonedDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public JobExecutionResponse getExecutionResponse() {
        return this.executionResponse;
    }

    public Integer getExecutionCounter() {
        return this.executionCounter;
    }

    public Optional<Long> hasInterval() {
        return Optional.ofNullable(this.getRepeatInterval()).filter(interval -> interval > 0L);
    }

    public static ScheduledJobBuilder builder() {
        return new ScheduledJobBuilder();
    }

    public String toString() {
        return new StringJoiner(", ", ScheduledJob.class.getSimpleName() + "[", "]").add("scheduledId='" + this.scheduledId + "'").add("retries=" + this.retries).add("status=" + this.status).add("lastUpdate=" + this.lastUpdate).add("executionResponse=" + this.executionResponse).add("executionCounter=" + this.executionCounter).add("job=" + super.toString()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledJob)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScheduledJob that = (ScheduledJob)((Object)o);
        return Objects.equals(this.getScheduledId(), that.getScheduledId()) && Objects.equals(this.getRetries(), that.getRetries()) && this.getStatus() == that.getStatus() && this.getLastUpdate().equals(that.getLastUpdate()) && Objects.equals(this.getExecutionCounter(), that.getExecutionCounter()) && Objects.equals(this.getExecutionResponse(), that.getExecutionResponse());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getScheduledId(), this.getRetries(), this.getStatus(), this.getLastUpdate(), this.getExecutionCounter(), this.getExecutionResponse()});
    }

    public static class ScheduledJobBuilder {
        private Job job;
        private String scheduledId;
        private Integer retries = 0;
        private JobStatus status;
        private ZonedDateTime lastUpdate;
        private ZonedDateTime expirationTime;
        private JobExecutionResponse executionResponse;
        private Integer executionCounter = 0;

        public ScheduledJobBuilder job(Job job) {
            this.job = job;
            return this;
        }

        public ScheduledJobBuilder scheduledId(String scheduledId) {
            this.scheduledId = scheduledId;
            return this;
        }

        public ScheduledJobBuilder expirationTime(ZonedDateTime expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public ScheduledJobBuilder retries(Integer retries) {
            this.retries = retries;
            return this;
        }

        public ScheduledJobBuilder incrementExecutionCounter() {
            Integer n = this.executionCounter;
            Integer n2 = this.executionCounter = Integer.valueOf(this.executionCounter + 1);
            return this;
        }

        public ScheduledJobBuilder incrementRetries() {
            Integer n = this.retries;
            Integer n2 = this.retries = Integer.valueOf(this.retries + 1);
            return this;
        }

        public ScheduledJobBuilder of(ScheduledJob scheduledJob) {
            return this.job(scheduledJob).scheduledId(scheduledJob.getScheduledId()).retries(scheduledJob.getRetries()).status(scheduledJob.getStatus()).executionResponse(scheduledJob.getExecutionResponse()).executionCounter(scheduledJob.getExecutionCounter());
        }

        public ScheduledJobBuilder status(JobStatus status) {
            this.status = status;
            return this;
        }

        public ScheduledJobBuilder lastUpdate(ZonedDateTime time) {
            this.lastUpdate = time;
            return this;
        }

        public ScheduledJobBuilder executionResponse(JobExecutionResponse executionResponse) {
            this.executionResponse = executionResponse;
            return this;
        }

        public ScheduledJobBuilder executionCounter(Integer executionCounter) {
            this.executionCounter = executionCounter;
            return this;
        }

        public ScheduledJob build() {
            ScheduledJob instance = new ScheduledJob(Optional.ofNullable(this.job), Optional.ofNullable(this.expirationTime));
            instance.scheduledId = this.scheduledId;
            instance.retries = this.retries;
            instance.status = this.status;
            instance.lastUpdate = this.getLastUpdate();
            instance.executionResponse = this.executionResponse;
            instance.executionCounter = this.executionCounter;
            instance.executionResponse = this.executionResponse;
            return instance;
        }

        private ZonedDateTime getLastUpdate() {
            return Optional.ofNullable(this.lastUpdate).orElseGet(DateUtil::now);
        }
    }
}

