/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.executor;

import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.service.converters.HttpConverters;
import org.kie.kogito.jobs.service.executor.HttpJobExecutor;
import org.kie.kogito.jobs.service.model.JobExecutionResponse;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.jobs.service.model.job.ScheduledJobAdapter;
import org.kie.kogito.jobs.service.stream.JobStreams;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class HttpJobExecutorTest {
    public static final String ENDPOINT = "http://localhost:8080/endpoint";
    public static final String JOB_ID = UUID.randomUUID().toString();
    @InjectMocks
    private HttpJobExecutor tested;
    @Mock
    private io.vertx.mutiny.core.Vertx vertx;
    @Spy
    private HttpConverters httpConverters = new HttpConverters();
    @Mock
    private JobStreams jobStreams;
    @Mock
    private WebClient webClient;

    HttpJobExecutorTest() {
    }

    @Test
    void testInitialize(@Mock Vertx vertxCore) {
        Mockito.when((Object)this.vertx.getDelegate()).thenReturn((Object)vertxCore);
        this.tested.initialize();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.tested.getClient());
    }

    @Test
    void testExecutePeriodic(@Mock HttpRequest<Buffer> request, @Mock MultiMap params) {
        JobDetails scheduledJob = JobDetails.builder().id(JOB_ID).recipient((Recipient)new Recipient.HTTPRecipient(ENDPOINT)).trigger((Trigger)ScheduledJobAdapter.intervalTrigger((ZonedDateTime)DateUtil.now(), (int)10, (int)1)).executionCounter(Integer.valueOf(1)).build();
        Map queryParams = this.assertExecuteAndReturnQueryParams(request, params, scheduledJob, false);
        Assertions.assertThat((Map)queryParams).hasSize(1).containsEntry((Object)"limit", (Object)"8");
    }

    private Map assertExecuteAndReturnQueryParams(@Mock HttpRequest<Buffer> request, @Mock MultiMap params, JobDetails scheduledJob, boolean mockError) {
        Mockito.when((Object)this.webClient.request(HttpMethod.POST, 8080, "localhost", "/endpoint")).thenReturn(request);
        Mockito.when((Object)request.queryParams()).thenReturn((Object)params);
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response.statusCode()).thenReturn((Object)(mockError ? 500 : 200));
        Mockito.when((Object)request.send()).thenReturn((Object)Uni.createFrom().item((Object)response));
        ArgumentCaptor mapCaptor = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(JobExecutionResponse.class);
        this.tested.execute(CompletableFuture.completedFuture(scheduledJob));
        ((WebClient)Mockito.verify((Object)this.webClient)).request(HttpMethod.POST, 8080, "localhost", "/endpoint");
        ((HttpRequest)Mockito.verify(request)).queryParams();
        ((MultiMap)Mockito.verify((Object)params)).addAll((Map)mapCaptor.capture());
        ((HttpRequest)Mockito.verify(request)).send();
        JobExecutionResponse jobExecutionResponse = mockError ? ((JobStreams)Mockito.verify((Object)this.jobStreams)).publishJobError((JobExecutionResponse)responseCaptor.capture()) : ((JobStreams)Mockito.verify((Object)this.jobStreams)).publishJobSuccess((JobExecutionResponse)responseCaptor.capture());
        JobExecutionResponse value = (JobExecutionResponse)responseCaptor.getValue();
        Assertions.assertThat((String)value.getJobId()).isEqualTo(JOB_ID);
        Assertions.assertThat((String)value.getCode()).isEqualTo(mockError ? "500" : "200");
        return (Map)mapCaptor.getValue();
    }

    @Test
    void testExecute(@Mock HttpRequest<Buffer> request, @Mock MultiMap params) {
        JobDetails job = this.createSimpleJob();
        Map queryParams = this.assertExecuteAndReturnQueryParams(request, params, job, false);
        Assertions.assertThat((Map)queryParams).isEmpty();
    }

    @Test
    void testExecuteWithError(@Mock HttpRequest<Buffer> request, @Mock MultiMap params) {
        JobDetails job = this.createSimpleJob();
        Map queryParams = this.assertExecuteAndReturnQueryParams(request, params, job, true);
        Assertions.assertThat((Map)queryParams).isEmpty();
    }

    private JobDetails createSimpleJob() {
        return JobDetails.builder().recipient((Recipient)new Recipient.HTTPRecipient(ENDPOINT)).id(JOB_ID).build();
    }
}

