/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.ClassLoadingResource;
import io.quarkus.bootstrap.runner.ManifestInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;

public final class RunnerClassLoader
extends ClassLoader {
    private final Map<String, ClassLoadingResource[]> resourceDirectoryMap;
    private final Set<String> parentFirstPackages;
    private final Set<String> nonExistentResources;
    private final Set<String> fullyIndexedDirectories;
    private final Map<String, ClassLoadingResource[]> directlyIndexedResourcesIndexMap;
    private final ClassLoadingResource[] currentlyBufferedResources = new ClassLoadingResource[4];
    private boolean postBootPhase = false;

    RunnerClassLoader(ClassLoader parent, Map<String, ClassLoadingResource[]> resourceDirectoryMap, Set<String> parentFirstPackages, Set<String> nonExistentResources, Set<String> fullyIndexedDirectories, Map<String, ClassLoadingResource[]> directlyIndexedResourcesIndexMap) {
        super(parent);
        this.resourceDirectoryMap = resourceDirectoryMap;
        this.parentFirstPackages = parentFirstPackages;
        this.nonExistentResources = nonExistentResources;
        this.fullyIndexedDirectories = fullyIndexedDirectories;
        this.directlyIndexedResourcesIndexMap = directlyIndexedResourcesIndexMap;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java.")) {
            return this.getParent().loadClass(name);
        }
        String packageName = this.getPackageNameFromClassName(name);
        if (this.parentFirstPackages.contains(packageName)) {
            try {
                return this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            ClassLoadingResource[] resources;
            Class<?> loaded = this.findLoadedClass(name);
            if (loaded != null) {
                return loaded;
            }
            if (packageName == null) {
                resources = this.resourceDirectoryMap.get("");
            } else {
                String dirName = packageName.replace('.', '/');
                resources = this.resourceDirectoryMap.get(dirName);
            }
            if (resources != null) {
                String classResource = name.replace('.', '/') + ".class";
                for (ClassLoadingResource resource : resources) {
                    this.accessingResource(resource);
                    byte[] data = resource.getResourceData(classResource);
                    if (data == null) continue;
                    this.definePackage(packageName, resources);
                    return this.defineClass(name, data, 0, data.length, resource.getProtectionDomain());
                }
            }
        }
        return this.getParent().loadClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accessingResource(ClassLoadingResource resource) {
        ClassLoadingResource[] classLoadingResourceArray = this.currentlyBufferedResources;
        synchronized (this.currentlyBufferedResources) {
            if (!this.postBootPhase) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            if (this.currentlyBufferedResources[0] == resource) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            for (int i = 1; i < this.currentlyBufferedResources.length; ++i) {
                ClassLoadingResource currentI = this.currentlyBufferedResources[i];
                if (currentI != resource && currentI != null) continue;
                ClassLoadingResource previous = this.currentlyBufferedResources[i - 1];
                this.currentlyBufferedResources[i - 1] = resource;
                this.currentlyBufferedResources[i] = previous;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            ClassLoadingResource toEvict = this.currentlyBufferedResources[this.currentlyBufferedResources.length - 1];
            this.currentlyBufferedResources[this.currentlyBufferedResources.length - 1] = resource;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            toEvict.resetInternalCaches();
            return;
        }
    }

    @Override
    protected URL findResource(String name) {
        if (this.nonExistentResources.contains(name = this.sanitizeName(name))) {
            return null;
        }
        ClassLoadingResource[] resources = this.getClassLoadingResources(name);
        if (resources == null) {
            return null;
        }
        for (ClassLoadingResource resource : resources) {
            this.accessingResource(resource);
            URL data = resource.getResourceURL(name);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    private String sanitizeName(String name) {
        if (name.length() > 0 && name.charAt(0) == '/') {
            return name.substring(1);
        }
        return name;
    }

    private ClassLoadingResource[] getClassLoadingResources(String name) {
        ClassLoadingResource[] resources = this.directlyIndexedResourcesIndexMap.get(name);
        if (resources != null) {
            return resources;
        }
        String dirName = this.getDirNameFromResourceName(name);
        if (dirName == null) {
            dirName = "";
        }
        if (!dirName.equals(name) && this.fullyIndexedDirectories.contains(dirName)) {
            return null;
        }
        resources = this.resourceDirectoryMap.get(dirName);
        if (resources == null) {
            resources = this.resourceDirectoryMap.get(name);
        }
        return resources;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        if (this.nonExistentResources.contains(name = this.sanitizeName(name))) {
            return Collections.emptyEnumeration();
        }
        ClassLoadingResource[] resources = this.getClassLoadingResources(name);
        if (resources == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoadingResource resource : resources) {
            this.accessingResource(resource);
            URL data = resource.getResourceURL(name);
            if (data == null) continue;
            urls.add(data);
        }
        return Collections.enumeration(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void definePackage(String pkgName, ClassLoadingResource[] resources) {
        if (pkgName != null && this.getPackage(pkgName) == null) {
            Object object = this.getClassLoadingLock(pkgName);
            synchronized (object) {
                if (this.getPackage(pkgName) == null) {
                    for (ClassLoadingResource classPathElement : resources) {
                        ManifestInfo mf = classPathElement.getManifestInfo();
                        if (mf == null) continue;
                        this.definePackage(pkgName, mf.getSpecTitle(), mf.getSpecVersion(), mf.getSpecVendor(), mf.getImplTitle(), mf.getImplVersion(), mf.getImplVendor(), null);
                        return;
                    }
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
        }
    }

    private String getPackageNameFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    private String getDirNameFromResourceName(String resourceName) {
        int index = resourceName.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return resourceName.substring(0, index);
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void close() {
        for (Map.Entry<String, ClassLoadingResource[]> entry : this.resourceDirectoryMap.entrySet()) {
            for (ClassLoadingResource i : entry.getValue()) {
                i.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInternalCaches() {
        ClassLoadingResource[] classLoadingResourceArray = this.currentlyBufferedResources;
        synchronized (this.currentlyBufferedResources) {
            for (Map.Entry<String, ClassLoadingResource[]> entry : this.resourceDirectoryMap.entrySet()) {
                for (ClassLoadingResource i : entry.getValue()) {
                    i.resetInternalCaches();
                }
            }
            this.postBootPhase = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        RunnerClassLoader.registerAsParallelCapable();
    }
}

