/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.common.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.resteasy.common.runtime.QuarkusInjectorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class QuarkusConstructorInjector
implements ConstructorInjector {
    private volatile BeanContainer.Factory<?> factory;
    private final ConstructorInjector delegate;
    private final Constructor<?> ctor;

    public QuarkusConstructorInjector(Constructor<?> ctor, ConstructorInjector delegate) {
        this.ctor = ctor;
        this.delegate = delegate;
    }

    @Override
    public Object construct(boolean unwrapAsync) {
        if (QuarkusInjectorFactory.CONTAINER == null) {
            return this.delegate.construct(unwrapAsync);
        }
        if (this.factory == null) {
            this.factory = QuarkusInjectorFactory.CONTAINER.instanceFactory(this.ctor.getDeclaringClass(), new Annotation[0]);
        }
        if (this.factory == null) {
            return this.delegate.construct(unwrapAsync);
        }
        return this.factory.create().get();
    }

    @Override
    public Object construct(HttpRequest request, HttpResponse response, boolean unwrapAsync) throws Failure, WebApplicationException, ApplicationException {
        if (QuarkusInjectorFactory.CONTAINER == null) {
            return this.delegate.construct(request, response, unwrapAsync);
        }
        if (this.factory == null) {
            this.factory = QuarkusInjectorFactory.CONTAINER.instanceFactory(this.ctor.getDeclaringClass(), new Annotation[0]);
        }
        if (this.factory == null) {
            return this.delegate.construct(request, response, unwrapAsync);
        }
        return this.factory.create().get();
    }

    @Override
    public Object injectableArguments(boolean unwrapAsync) {
        return this.delegate.injectableArguments(unwrapAsync);
    }

    @Override
    public Object injectableArguments(HttpRequest request, HttpResponse response, boolean unwrapAsync) throws Failure {
        return this.delegate.injectableArguments(request, response, unwrapAsync);
    }
}

