/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.health;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HealthReport {
    public static final HealthReport OK_INSTANCE = new HealthReport(Collections.emptyList());
    private final boolean ok;
    private final List<ChannelInfo> channels;

    public HealthReport(List<ChannelInfo> channels) {
        this.channels = Collections.unmodifiableList(channels);
        for (ChannelInfo info : channels) {
            if (info.isOk()) continue;
            this.ok = false;
            return;
        }
        this.ok = true;
    }

    public boolean isOk() {
        return this.ok;
    }

    public List<ChannelInfo> getChannels() {
        return this.channels;
    }

    public static HealthReportBuilder builder() {
        return new HealthReportBuilder();
    }

    public static class HealthReportBuilder {
        private final List<ChannelInfo> channels = new ArrayList<ChannelInfo>();

        private HealthReportBuilder() {
        }

        public HealthReportBuilder add(ChannelInfo info) {
            this.channels.add(info);
            return this;
        }

        public HealthReportBuilder add(String channel, boolean ok) {
            return this.add(new ChannelInfo(channel, ok));
        }

        public HealthReportBuilder add(String channel, boolean ok, String message) {
            return this.add(new ChannelInfo(channel, ok, message));
        }

        public HealthReport build() {
            return new HealthReport(this.channels);
        }
    }

    public static class ChannelInfo {
        private final String channel;
        private final String message;
        private final boolean ok;

        public ChannelInfo(String channel, boolean ok, String message) {
            this.channel = channel;
            this.message = message;
            this.ok = ok;
        }

        public ChannelInfo(String channel, boolean ok) {
            this(channel, ok, null);
        }

        public String getChannel() {
            return this.channel;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isOk() {
            return this.ok;
        }
    }
}

