/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Response;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.ext.auth.oauth2.impl.flow.AbstractOAuth2Flow;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;
import java.io.UnsupportedEncodingException;

public class AuthJWTImpl
extends AbstractOAuth2Flow
implements OAuth2Flow {
    private final OAuth2AuthProviderImpl provider;

    public AuthJWTImpl(OAuth2AuthProviderImpl provider) {
        super(provider.getVertx(), provider.getConfig());
        this.provider = provider;
        AuthJWTImpl.throwIfNull("clientId", this.config.getClientID());
        AuthJWTImpl.throwIfNull("pubSecKeys", this.config.getPubSecKeys());
        if (this.config.getPubSecKeys().size() == 0) {
            AuthJWTImpl.throwIfNull("pubSecKey", null);
        }
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> callback) {
        JsonObject body = new JsonObject().put("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer").put("assertion", this.provider.getJWT().sign(params, this.provider.getConfig().getJWTOptions()));
        OAuth2API.fetch(this.provider.getVertx(), this.provider.getConfig(), HttpMethod.POST, this.provider.getConfig().getTokenPath(), new JsonObject().put("Content-Type", "application/x-www-form-urlencoded"), Buffer.buffer(OAuth2API.stringify(body)), fetch -> {
            JsonObject token;
            if (fetch.failed()) {
                callback.handle(Future.failedFuture(fetch.cause()));
                return;
            }
            OAuth2Response res = (OAuth2Response)fetch.result();
            if (res.is("application/json")) {
                try {
                    token = res.jsonObject();
                }
                catch (RuntimeException e) {
                    callback.handle(Future.failedFuture(e));
                    return;
                }
            } else if (res.is("application/x-www-form-urlencoded") || res.is("text/plain")) {
                try {
                    token = OAuth2API.queryToJSON(res.body().toString());
                }
                catch (UnsupportedEncodingException | RuntimeException e) {
                    callback.handle(Future.failedFuture(e));
                    return;
                }
            } else {
                callback.handle(Future.failedFuture("Cannot handle Content-Type: " + res.headers().get("Content-Type")));
                return;
            }
            callback.handle(Future.succeededFuture(new OAuth2TokenImpl(this.provider, token)));
        });
    }
}

