/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.client.impl.WebClientSessionAware;
import io.vertx.ext.web.client.spi.CookieStore;
import java.net.URI;
import java.util.List;

public class SessionAwareInterceptor
implements Handler<HttpContext<?>> {
    private static final String HEADERS_CONTEXT_KEY = "_originalHeaders";

    @Override
    public void handle(HttpContext<?> context) {
        switch (context.phase()) {
            case PREPARE_REQUEST: {
                this.prepareRequest(context);
                break;
            }
            case FOLLOW_REDIRECT: {
                this.processRedirectCookies(context);
                break;
            }
            case DISPATCH_RESPONSE: {
                this.processResponse(context);
                break;
            }
        }
        context.next();
    }

    private void prepareRequest(HttpContext<?> context) {
        Iterable<Cookie> cookies;
        String encodedCookies;
        HttpRequestImpl request = (HttpRequestImpl)context.request();
        WebClientSessionAware webclient = (WebClientSessionAware)request.client;
        MultiMap headers = (MultiMap)context.get(HEADERS_CONTEXT_KEY);
        if (headers == null) {
            headers = new CaseInsensitiveHeaders().addAll(request.headers());
            context.set(HEADERS_CONTEXT_KEY, headers);
        }
        request.headers().clear().addAll(headers).addAll(webclient.headers());
        String domain = request.virtualHost;
        if (domain == null) {
            domain = request.host;
        }
        if ((encodedCookies = ClientCookieEncoder.STRICT.encode(cookies = webclient.cookieStore().get(request.ssl, domain, request.uri))) != null) {
            request.headers().add(HttpHeaders.COOKIE, (CharSequence)encodedCookies);
        }
    }

    private void processRedirectCookies(HttpContext<?> context) {
        this.processRedirectResponse(context);
        this.prepareRedirectRequest(context);
    }

    private void processRedirectResponse(HttpContext<?> context) {
        List<String> cookieHeaders = context.clientResponse().cookies();
        if (cookieHeaders == null) {
            return;
        }
        WebClientSessionAware webclient = (WebClientSessionAware)((HttpRequestImpl)context.request()).client;
        HttpRequestImpl originalRequest = (HttpRequestImpl)context.request();
        CookieStore cookieStore = webclient.cookieStore();
        String domain = URI.create(context.clientResponse().request().absoluteURI()).getHost();
        if (domain.equals(originalRequest.host) && originalRequest.virtualHost != null) {
            domain = originalRequest.virtualHost;
        }
        String finalDomain = domain;
        cookieHeaders.forEach(header -> {
            Cookie cookie = ClientCookieDecoder.STRICT.decode((String)header);
            if (cookie != null) {
                if (cookie.domain() == null) {
                    cookie.setDomain(finalDomain);
                }
                cookieStore.put(cookie);
            }
        });
    }

    private void prepareRedirectRequest(HttpContext<?> context) {
        String redirectHost;
        HttpClientRequest redirectRequest = context.clientRequest();
        HttpRequestImpl originalRequest = (HttpRequestImpl)context.request();
        WebClientSessionAware webclient = (WebClientSessionAware)originalRequest.client;
        MultiMap headers = (MultiMap)context.get(HEADERS_CONTEXT_KEY);
        if (headers == null) {
            headers = new CaseInsensitiveHeaders().addAll(redirectRequest.headers());
            context.set(HEADERS_CONTEXT_KEY, headers);
        }
        String domain = (redirectHost = URI.create(redirectRequest.absoluteURI()).getHost()).equals(originalRequest.host) && originalRequest.virtualHost != null ? originalRequest.virtualHost : redirectHost;
        Iterable<Cookie> cookies = webclient.cookieStore().get(originalRequest.ssl, domain, redirectRequest.path());
        String encodedCookies = ClientCookieEncoder.STRICT.encode(cookies);
        if (encodedCookies != null) {
            redirectRequest.headers().add(HttpHeaders.COOKIE, (CharSequence)encodedCookies);
        }
    }

    private void processResponse(HttpContext<?> context) {
        List<String> cookieHeaders = context.clientResponse().cookies();
        if (cookieHeaders == null) {
            return;
        }
        WebClientSessionAware webclient = (WebClientSessionAware)((HttpRequestImpl)context.request()).client;
        HttpRequestImpl request = (HttpRequestImpl)context.request();
        CookieStore cookieStore = webclient.cookieStore();
        cookieHeaders.forEach(header -> {
            Cookie cookie = ClientCookieDecoder.STRICT.decode((String)header);
            if (cookie != null) {
                if (cookie.domain() == null) {
                    cookie.setDomain(request.virtualHost != null ? request.virtualHost : request.host);
                }
                cookieStore.put(cookie);
            }
        });
    }
}

