/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging;

import io.smallrye.common.annotation.Experimental;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

@Experimental(value="metadata propagation is a SmallRye-specific feature")
public class Metadata
implements Iterable<Object> {
    private final Set<Object> backend;
    private static final Metadata EMPTY = new Metadata(Collections.emptySet());

    private Metadata(Set<Object> backend) {
        this.backend = Collections.unmodifiableSet(backend);
    }

    public static Metadata empty() {
        return EMPTY;
    }

    static Metadata of(Object metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("`metadata` must not be `null`");
        }
        return new Metadata(Collections.singleton(metadata));
    }

    public static Metadata of(Object ... metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("`metadata` must not be `null`");
        }
        Set<Object> set = Metadata.addMetadataToSet(Arrays.asList(metadata));
        return new Metadata(set);
    }

    public static Metadata from(Iterable<Object> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("`iterable` must not be `null`");
        }
        if (iterable instanceof Metadata) {
            return (Metadata)iterable;
        }
        Set<Object> set = Metadata.addMetadataToSet(iterable);
        if (set.isEmpty()) {
            return Metadata.empty();
        }
        return new Metadata(set);
    }

    private static Set<Object> addMetadataToSet(Iterable<Object> iterable) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object meta : iterable) {
            if (meta == null) {
                throw new IllegalArgumentException("One of the item is `null`");
            }
            if (Metadata.contains(set, meta)) {
                throw new IllegalArgumentException("Duplicated metadata detected: " + meta.getClass().getName());
            }
            set.add(meta);
        }
        return set;
    }

    private static boolean contains(Set<Object> set, Object meta) {
        Class<?> clazz = meta.getClass();
        for (Object o : set) {
            if (!o.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private static void replaceOrAdd(Set<Object> set, Object meta) {
        Class<?> clazz = meta.getClass();
        for (Object o : set) {
            if (!o.getClass().equals(clazz)) continue;
            set.remove(o);
            set.add(meta);
            return;
        }
        set.add(meta);
    }

    public Metadata with(Object meta) {
        if (meta == null) {
            throw new IllegalArgumentException("`meta` must not be `null`");
        }
        HashSet<Object> copy = new HashSet<Object>(this.backend);
        Metadata.replaceOrAdd(copy, meta);
        return new Metadata(copy);
    }

    public Metadata without(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("`clazz` must not be `null`");
        }
        LinkedHashSet<Object> copy = new LinkedHashSet<Object>(this.backend);
        copy.stream().filter(o -> o.getClass().equals(clazz)).findAny().ifPresent(copy::remove);
        return new Metadata(copy);
    }

    public Metadata copy() {
        LinkedHashSet<Object> copy = new LinkedHashSet<Object>(this.backend);
        return new Metadata(copy);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.backend.iterator();
    }
}

