/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Properties;
import java.util.regex.Pattern;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;

public class NearCacheConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<NearCacheConfiguration> {
    private NearCacheMode mode = NearCacheMode.DISABLED;
    private Integer maxEntries = null;
    private Pattern cacheNamePattern = null;

    protected NearCacheConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public NearCacheConfigurationBuilder maxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    public NearCacheConfigurationBuilder mode(NearCacheMode mode) {
        this.mode = mode;
        return this;
    }

    @Deprecated
    public NearCacheConfigurationBuilder cacheNamePattern(String pattern) {
        this.cacheNamePattern = Pattern.compile(pattern);
        return this;
    }

    @Deprecated
    public NearCacheConfigurationBuilder cacheNamePattern(Pattern pattern) {
        this.cacheNamePattern = pattern;
        return this;
    }

    @Override
    public void validate() {
        if (this.mode.enabled() && this.maxEntries == null) {
            throw Log.HOTROD.nearCacheMaxEntriesUndefined();
        }
    }

    @Override
    public NearCacheConfiguration create() {
        return new NearCacheConfiguration(this.mode, this.maxEntries == null ? -1 : this.maxEntries, this.cacheNamePattern);
    }

    @Override
    public Builder<?> read(NearCacheConfiguration template) {
        this.mode = template.mode();
        this.maxEntries = template.maxEntries();
        this.cacheNamePattern = template.cacheNamePattern();
        return this;
    }

    @Override
    public ConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties(properties);
        if (typed.containsKey("infinispan.client.hotrod.near_cache.max_entries")) {
            this.maxEntries(typed.getIntProperty("infinispan.client.hotrod.near_cache.max_entries", -1));
        }
        if (typed.containsKey("infinispan.client.hotrod.near_cache.mode")) {
            this.mode(NearCacheMode.valueOf(typed.getProperty("infinispan.client.hotrod.near_cache.mode")));
        }
        if (typed.containsKey("infinispan.client.hotrod.near_cache.name_pattern")) {
            this.cacheNamePattern(typed.getProperty("infinispan.client.hotrod.near_cache.name_pattern"));
        }
        return this.builder;
    }
}

