/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan;

import io.quarkus.runtime.StartupEvent;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Readiness;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.kie.kogito.infinispan.health.InfinispanHealthCheck;
import org.kie.kogito.jobs.service.repository.infinispan.InfinispanInitialized;

@ApplicationScoped
public class InfinispanConfiguration {
    public static final String PERSISTENCE_CONFIG_KEY = "kogito.jobs-service.persistence";
    public static final String CACHE_TEMPLATE_XML = "META-INF/kogito-cache-default.xml";
    private AtomicBoolean initialized = new AtomicBoolean(Boolean.FALSE);

    @Produces
    @Readiness
    public HealthCheck infinispanHealthCheck(@ConfigProperty(name="kogito.jobs-service.persistence") Optional<String> persistence, Instance<RemoteCacheManager> cacheManagerInstance) {
        return this.isEnabled(persistence).map(p -> new InfinispanHealthCheck(cacheManagerInstance)).orElse(() -> HealthCheckResponse.up("In Memory Persistence"));
    }

    private Optional<String> isEnabled(Optional<String> persistence) {
        return persistence.filter("infinispan"::equals);
    }

    void initializeCaches(@Observes @Priority(value=0) StartupEvent startupEvent, @ConfigProperty(name="kogito.jobs-service.persistence") Optional<String> persistence, Instance<RemoteCacheManager> remoteCacheManager, Event<InfinispanInitialized> initializedEvent) {
        this.isEnabled(persistence).map(c -> ((RemoteCacheManager)remoteCacheManager.get()).getCache("JOB_DETAILS")).ifPresent(c -> {
            initializedEvent.fire(new InfinispanInitialized());
            this.initialized.set(Boolean.TRUE);
        });
    }

    protected Boolean isInitialized() {
        return this.initialized.get();
    }

    public static class Caches {
        public static final String JOB_DETAILS = "JOB_DETAILS";

        private Caches() {
        }
    }
}

