/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan;

import io.vertx.core.Vertx;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.qualifier.Repository;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.repository.impl.BaseReactiveJobRepository;
import org.kie.kogito.jobs.service.repository.infinispan.InfinispanInitialized;
import org.kie.kogito.jobs.service.stream.JobStreams;

@ApplicationScoped
@Repository(value="infinispan")
public class InfinispanJobRepository
extends BaseReactiveJobRepository
implements ReactiveJobRepository {
    private RemoteCache<String, JobDetails> cache;
    private QueryFactory queryFactory;
    private RemoteCacheManager remoteCacheManager;

    InfinispanJobRepository() {
        super(null, null);
    }

    @Inject
    public InfinispanJobRepository(Vertx vertx, JobStreams jobStreams, RemoteCacheManager remoteCacheManager) {
        super(vertx, jobStreams);
        this.remoteCacheManager = remoteCacheManager;
    }

    void init(@Observes InfinispanInitialized event) {
        this.cache = this.remoteCacheManager.getCache("JOB_DETAILS");
        this.queryFactory = Search.getQueryFactory(this.cache);
    }

    @Override
    public CompletionStage<JobDetails> doSave(JobDetails job) {
        return this.runAsync(() -> this.cache.put(job.getId(), job)).thenApply(j -> job);
    }

    @Override
    public CompletionStage<JobDetails> get(String id) {
        return this.runAsync(() -> (JobDetails)this.cache.get(id));
    }

    @Override
    public CompletionStage<Boolean> exists(String id) {
        return this.runAsync(() -> this.cache.containsKey(id));
    }

    @Override
    public CompletionStage<JobDetails> delete(String id) {
        return this.runAsync(() -> this.cache.withFlags(Flag.FORCE_RETURN_VALUE).remove(id));
    }

    @Override
    public PublisherBuilder<JobDetails> findAll() {
        Query query = this.queryFactory.create("from job.service.JobDetails");
        return ReactiveStreams.fromIterable(query.execute().list());
    }

    @Override
    public PublisherBuilder<JobDetails> findByStatus(JobStatus ... status) {
        Query query = this.queryFactory.create("from job.service.JobDetails j where j.status in (" + this.createStatusQuery(status) + ")");
        return ReactiveStreams.fromIterable(query.execute().list());
    }

    @Override
    public PublisherBuilder<JobDetails> findByStatusBetweenDatesOrderByPriority(ZonedDateTime from, ZonedDateTime to, JobStatus ... status) {
        Query query = this.queryFactory.create("from job.service.JobDetails j where j.trigger.nextFireTime > :from and j.trigger.nextFireTime < :to and j.status in (" + this.createStatusQuery(status) + ") order by j.priority desc");
        query.setParameter("to", to.toInstant().toEpochMilli());
        query.setParameter("from", from.toInstant().toEpochMilli());
        return ReactiveStreams.fromIterable(query.execute().list());
    }

    private String createStatusQuery(JobStatus[] status) {
        return Arrays.stream(status).map(Enum::name).collect(Collectors.joining("', '", "'", "'"));
    }
}

