/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import org.wildfly.security.permission.AbstractActionPermission;
import org.wildfly.security.permission.PermissionUtil;
import org.wildfly.security.util.StringEnumeration;

public abstract class AbstractActionSetPermission<This extends AbstractActionSetPermission<This>>
extends AbstractActionPermission<This> {
    private static final long serialVersionUID = 897239118282921196L;
    private final StringEnumeration actionEnumeration;
    private final int actionBits;
    private String actions;

    protected AbstractActionSetPermission(String name, int actionBits, StringEnumeration actionEnumeration) {
        super(name);
        this.actionEnumeration = actionEnumeration;
        this.actionBits = actionBits & this.actionsMask();
        if (actionBits == this.actionsMask()) {
            this.actions = "*";
        }
    }

    protected AbstractActionSetPermission(String name, String actions, StringEnumeration actionEnumeration) {
        super(name);
        this.actionEnumeration = actionEnumeration;
        int actionBits = this.parseActions(actions);
        this.actionBits = actionBits & this.actionsMask();
        if (actionBits == this.actionsMask()) {
            this.actions = "*";
        }
    }

    public final int getActionBits() {
        return this.actionBits;
    }

    @Override
    public final boolean actionsEquals(This permission) {
        return permission != null && this.actionBits == ((AbstractActionSetPermission)permission).getActionBits();
    }

    @Override
    public final boolean impliesActions(This permission) {
        return permission != null && AbstractActionSetPermission.isSet(this.actionBits, ((AbstractActionSetPermission)permission).getActionBits());
    }

    @Override
    public final boolean impliesActions(String actions) {
        return this.impliesActionBits(this.parseActions(actions));
    }

    public final boolean impliesActionBits(int actionBits) {
        return AbstractActionSetPermission.isSet(this.actionBits, actionBits & this.actionsMask());
    }

    private int actionsMask() {
        return (1 << this.actionEnumeration.size()) - 1;
    }

    private int getActionBit(String actionName) throws IllegalArgumentException {
        return 1 << this.actionEnumeration.indexOf(actionName);
    }

    private String getActionName(int bit) throws IllegalArgumentException {
        return this.actionEnumeration.nameOf(Integer.numberOfTrailingZeros(bit));
    }

    @Override
    protected final int actionsHashCode() {
        return this.actionBits;
    }

    @Override
    public final String getActions() {
        String actions = this.actions;
        if (actions != null) {
            return actions;
        }
        this.actions = PermissionUtil.toActionsString(this.actionBits, this::getActionName);
        return this.actions;
    }

    public final int parseActions(String actionsString) throws IllegalArgumentException {
        return PermissionUtil.parseActions(actionsString, this::getActionBit);
    }

    @Override
    public final This withActions(String actionsString) {
        return this.withActionBits(this.parseActions(actionsString));
    }

    @Override
    public final This withActionsFrom(This permission) {
        return this.withActionBits(((AbstractActionSetPermission)permission).getActionBits());
    }

    public final This withActionBits(int actionBits) {
        return this.withNewActionBits(this.actionBits | actionBits & this.actionsMask());
    }

    @Override
    public final This withoutActions(String actionsString) {
        return this.withoutActionBits(this.parseActions(actionsString));
    }

    @Override
    public final This withoutActionsFrom(This permission) {
        return this.withoutActionBits(((AbstractActionSetPermission)permission).getActionBits());
    }

    public final This withoutActionBits(int actionBits) {
        return this.withNewActionBits(this.actionBits & ~actionBits);
    }

    @Override
    public final This withNewActions(String actionsString) {
        return this.withNewActionBits(this.parseActions(actionsString));
    }

    @Override
    public final This withNewActionsFrom(This permission) {
        return this.withNewActionBits(((AbstractActionSetPermission)permission).getActionBits());
    }

    public final This withNewActionBits(int actionBits) {
        int masked = actionBits & this.actionsMask();
        if (masked == this.actionBits) {
            return (This)this;
        }
        return this.constructWithActionBits(masked);
    }

    protected abstract This constructWithActionBits(int var1);

    private static boolean isSet(int bits, int test2) {
        return (bits & test2) == test2;
    }
}

