/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.model.job;

import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.job.HttpJob;
import org.kie.kogito.jobs.service.model.job.JobDetailsBuilder;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.timer.Job;
import org.kie.kogito.timer.Trigger;

public class JobDetails {
    private String id;
    private String correlationId;
    private JobStatus status;
    private ZonedDateTime lastUpdate;
    private Integer retries;
    private Integer priority;
    private Integer executionCounter;
    private String scheduledId;
    private Object payload;
    private Recipient recipient;
    private Trigger trigger;
    private Type type;

    protected JobDetails(String id, String correlationId, JobStatus status, ZonedDateTime lastUpdate, Integer retries, Integer executionCounter, String scheduledId, Object payload, Recipient recipient, Trigger trigger, Type type, Integer priority) {
        this.id = id;
        this.correlationId = correlationId;
        this.status = status;
        this.lastUpdate = lastUpdate;
        this.retries = retries;
        this.executionCounter = executionCounter;
        this.scheduledId = scheduledId;
        this.payload = payload;
        this.recipient = recipient;
        this.trigger = trigger;
        this.type = type;
        this.priority = priority;
    }

    public String getId() {
        return this.id;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public ZonedDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public Integer getExecutionCounter() {
        return this.executionCounter;
    }

    public String getScheduledId() {
        return this.scheduledId;
    }

    public Object getPayload() {
        return this.payload;
    }

    public Recipient getRecipient() {
        return this.recipient;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Type getType() {
        return this.type;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public static JobDetailsBuilder builder() {
        return new JobDetailsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobDetails)) {
            return false;
        }
        JobDetails that = (JobDetails)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getCorrelationId(), that.getCorrelationId()) && Objects.equals((Object)this.getStatus(), (Object)that.getStatus()) && Objects.equals(this.getLastUpdate(), that.getLastUpdate()) && Objects.equals(this.getRetries(), that.getRetries()) && Objects.equals(this.getExecutionCounter(), that.getExecutionCounter()) && Objects.equals(this.getScheduledId(), that.getScheduledId()) && Objects.equals(this.getRecipient(), that.getRecipient()) && Objects.equals(this.getTrigger().hasNextFireTime(), that.getTrigger().hasNextFireTime()) && Objects.equals((Object)this.getType(), (Object)that.getType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getId(), this.getCorrelationId(), this.getStatus(), this.getLastUpdate(), this.getRetries(), this.getExecutionCounter(), this.getScheduledId(), this.getPayload(), this.getRecipient(), this.getTrigger(), this.getType()});
    }

    public String toString() {
        return new StringJoiner(", ", JobDetails.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("correlationId='" + this.correlationId + "'").add("status=" + this.status).add("lastUpdate=" + this.lastUpdate).add("retries=" + this.retries).add("executionCounter=" + this.executionCounter).add("scheduledId='" + this.scheduledId + "'").add("payload=" + this.payload).add("recipient=" + this.recipient).add("trigger=" + this.trigger).add("type=" + this.type).toString();
    }

    public static enum Type {
        HTTP(HttpJob.class);

        private Class<? extends Job> jobClass;

        private Type(Class<? extends Job> jobClass) {
            this.jobClass = jobClass;
        }

        public Class<? extends Job> getJobClass() {
            return this.jobClass;
        }
    }
}

