/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.model.job;

import java.time.ZonedDateTime;
import java.util.Optional;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.timer.Trigger;

public class JobDetailsBuilder {
    private String id;
    private String correlationId;
    private JobStatus status;
    private ZonedDateTime lastUpdate;
    private Integer retries = 0;
    private Integer executionCounter = 0;
    private String scheduledId;
    private Object payload;
    private Recipient recipient;
    private Trigger trigger;
    private JobDetails.Type type;
    private Integer priority;

    public JobDetailsBuilder id(String id) {
        this.id = id;
        return this;
    }

    public JobDetailsBuilder correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public JobDetailsBuilder status(JobStatus status) {
        this.status = status;
        return this;
    }

    public JobDetailsBuilder lastUpdate(ZonedDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    public JobDetailsBuilder retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    public JobDetailsBuilder executionCounter(Integer executionCounter) {
        this.executionCounter = executionCounter;
        return this;
    }

    public JobDetailsBuilder scheduledId(String scheduledId) {
        this.scheduledId = scheduledId;
        return this;
    }

    public JobDetailsBuilder payload(Object payload) {
        this.payload = payload;
        return this;
    }

    public JobDetailsBuilder recipient(Recipient recipient) {
        this.recipient = recipient;
        return this;
    }

    public JobDetailsBuilder trigger(Trigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public JobDetailsBuilder type(JobDetails.Type type) {
        this.type = type;
        return this;
    }

    public JobDetailsBuilder priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public JobDetails build() {
        return new JobDetails(this.id, this.correlationId, this.status, this.lastUpdate, this.retries, this.executionCounter, this.scheduledId, this.payload, this.recipient, this.trigger, this.type, this.priority);
    }

    public JobDetailsBuilder of(JobDetails jobDetails) {
        return this.id(jobDetails.getId()).correlationId(jobDetails.getCorrelationId()).status(jobDetails.getStatus()).lastUpdate(jobDetails.getLastUpdate()).retries(jobDetails.getRetries()).executionCounter(jobDetails.getExecutionCounter()).scheduledId(jobDetails.getScheduledId()).payload(jobDetails.getPayload()).recipient(jobDetails.getRecipient()).trigger(jobDetails.getTrigger()).type(jobDetails.getType()).priority(jobDetails.getPriority());
    }

    public JobDetailsBuilder incrementRetries() {
        Integer n = this.retries;
        Integer n2 = this.retries = Integer.valueOf(this.retries + 1);
        return this;
    }

    public JobDetailsBuilder incrementExecutionCounter() {
        Integer n = this.executionCounter;
        Integer n2 = this.executionCounter = Integer.valueOf(this.executionCounter + 1);
        return this;
    }

    public JobDetailsBuilder merge(JobDetails jobDetails) {
        Optional<JobDetails> j = Optional.ofNullable(jobDetails);
        return this.scheduledId(j.map(JobDetails::getScheduledId).orElse(this.scheduledId)).retries(j.map(JobDetails::getRetries).orElse(this.retries)).status(j.map(JobDetails::getStatus).orElse(this.status)).id(j.map(JobDetails::getId).orElse(this.id)).trigger(j.map(JobDetails::getTrigger).orElse(this.trigger)).recipient(j.map(JobDetails::getRecipient).orElse(this.recipient)).correlationId(j.map(JobDetails::getCorrelationId).orElse(this.correlationId)).type(j.map(JobDetails::getType).orElse(this.type)).priority(j.map(JobDetails::getPriority).orElse(this.priority)).payload(j.map(JobDetails::getPayload).orElse(this.payload)).executionCounter(j.map(JobDetails::getExecutionCounter).orElse(this.executionCounter));
    }
}

