/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.kafka;

import java.util.UUID;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.kafka.KafkaProcessInstances;
import org.kie.kogito.persistence.kafka.KafkaStreamsStateListener;
import org.kie.kogito.process.Process;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class KafkaStreamsStateListenerTest {
    @Mock
    KafkaStreams streams;
    @Mock
    KafkaProcessInstances pi;
    @Mock
    Process process;
    @Spy
    KafkaStreamsStateListener listener;

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.process.id()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)this.pi.getProcess()).thenReturn((Object)this.process);
        this.listener.setKafkaStreams(this.streams);
    }

    @Test
    public void testSetStore() {
        this.listener.addProcessInstances(this.pi);
        this.listener.onChange(KafkaStreams.State.RUNNING, KafkaStreams.State.REBALANCING);
        ((KafkaProcessInstances)Mockito.verify((Object)this.pi)).setStore((ReadOnlyKeyValueStore)ArgumentMatchers.any());
        ((KafkaStreams)Mockito.verify((Object)this.streams)).store((StoreQueryParameters)ArgumentMatchers.any());
        Assertions.assertThat((Iterable)this.listener.getInstances()).hasSize(1);
        Assertions.assertThat((Object)this.listener.getKafkaStreams()).isEqualTo((Object)this.streams);
        this.listener.close();
        Assertions.assertThat((Iterable)this.listener.getInstances()).isEmpty();
    }

    @Test
    public void testSetStoreWhenRunning() {
        Mockito.when((Object)this.streams.state()).thenReturn((Object)KafkaStreams.State.RUNNING);
        this.listener.addProcessInstances(this.pi);
        ((KafkaProcessInstances)Mockito.verify((Object)this.pi)).setStore((ReadOnlyKeyValueStore)ArgumentMatchers.any());
        ((KafkaStreams)Mockito.verify((Object)this.streams)).store((StoreQueryParameters)ArgumentMatchers.any());
        Assertions.assertThat((Iterable)this.listener.getInstances()).hasSize(1);
        this.listener.close();
        Assertions.assertThat((Iterable)this.listener.getInstances()).isEmpty();
    }

    @Test
    public void testStoreNoSet() {
        this.listener.addProcessInstances(this.pi);
        this.listener.onChange(KafkaStreams.State.REBALANCING, KafkaStreams.State.CREATED);
        ((KafkaProcessInstances)Mockito.verify((Object)this.pi, (VerificationMode)Mockito.never())).setStore((ReadOnlyKeyValueStore)ArgumentMatchers.any());
        ((KafkaStreams)Mockito.verify((Object)this.streams, (VerificationMode)Mockito.never())).store((StoreQueryParameters)ArgumentMatchers.any());
    }
}

