/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.kafka;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.kie.kogito.persistence.kafka.KafkaPersistenceUtils;
import org.kie.kogito.persistence.kafka.KafkaProcessInstances;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KafkaStreamsStateListener
implements KafkaStreams.StateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaStreamsStateListener.class);
    private Map<String, KafkaProcessInstances> instances = new ConcurrentHashMap<String, KafkaProcessInstances>();
    private KafkaStreams streams;

    protected KafkaStreams getKafkaStreams() {
        return this.streams;
    }

    @Inject
    public void setKafkaStreams(KafkaStreams streams) {
        this.streams = streams;
        this.streams.setStateListener((KafkaStreams.StateListener)this);
    }

    @PreDestroy
    public void close() {
        this.instances.clear();
    }

    protected Collection<KafkaProcessInstances> getInstances() {
        return this.instances.values();
    }

    public void onChange(KafkaStreams.State newState, KafkaStreams.State oldState) {
        LOGGER.debug("Received change from KafkaStreams to new state: {}", (Object)newState);
        if (newState == KafkaStreams.State.RUNNING) {
            this.instances.forEach((id, pi) -> {
                LOGGER.info("Creating store for process: {}", id);
                this.setStore((KafkaProcessInstances)pi);
            });
        }
    }

    private void setStore(KafkaProcessInstances pi) {
        pi.setStore((ReadOnlyKeyValueStore<String, byte[]>)((ReadOnlyKeyValueStore)this.streams.store(StoreQueryParameters.fromNameAndType((String)KafkaPersistenceUtils.storeName(pi.getProcess().id()), (QueryableStoreType)QueryableStoreTypes.keyValueStore()))));
    }

    public void addProcessInstances(KafkaProcessInstances pi) {
        LOGGER.debug("Adding process instance into listener for process: {}", (Object)pi.getProcess().id());
        if (this.streams.state() == KafkaStreams.State.RUNNING) {
            this.setStore(pi);
        }
        this.instances.put(pi.getProcess().id(), pi);
    }
}

