/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.knative.ce.http;

import io.cloudevents.CloudEvent;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.kie.kogito.events.knative.ce.CloudEventConverter;
import org.kie.kogito.events.knative.ce.Printer;
import org.kie.kogito.events.knative.ce.http.Responses;
import org.kie.kogito.events.knative.ce.http.RestEasyHttpRequestConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class CloudEventListenerResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudEventListenerResource.class);

    @POST
    @Consumes(value={"application/json", "application/cloudevents+json", "text/plain"})
    @Produces(value={"application/json"})
    public Response cloudEventListener(@Context HttpRequest request) {
        try {
            CloudEvent event = new RestEasyHttpRequestConverter().from(request);
            LOGGER.info("CloudEvent processed: {}", (Object)Printer.beautify((CloudEvent)event));
            return Response.ok((Object)CloudEventConverter.toJson((CloudEvent)event)).build();
        }
        catch (Exception ex) {
            LOGGER.debug("Fail to process CloudEvent: ", (Throwable)ex);
            return Responses.errorProcessingCloudEvent((Throwable)ex);
        }
    }
}

