/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.knative.ce.http;

import io.cloudevents.CloudEvent;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.kogito.events.knative.ce.Printer;
import org.kie.kogito.events.knative.ce.http.Responses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class CloudEventListenerResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudEventListenerResource.class);

    @POST
    @Consumes(value={"application/json", "application/cloudevents+json"})
    @Produces(value={"application/json"})
    public Response cloudEventListener(CloudEvent event) {
        try {
            LOGGER.info("CloudEvent processed: {}", (Object)Printer.beautify((CloudEvent)event));
            return Response.ok((Object)event).build();
        }
        catch (Exception ex) {
            LOGGER.error("Fail to process CloudEvent: ", (Throwable)ex);
            return Responses.errorProcessingCloudEvent((Throwable)ex);
        }
    }
}

