/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloudevents.extension;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.impl.BaseCloudEventBuilder;
import io.cloudevents.core.provider.ExtensionProvider;
import java.net.URI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.cloudevents.CloudEventUtils;
import org.kie.kogito.cloudevents.extension.KogitoExtension;

public class KogitoExtensionTest {
    private static final String TEST_ID = "test-cloudevent-id";
    private static final String TEST_SOURCE = "http://test-cloudevent-source";
    private static final String TEST_TYPE = "test-cloudevent-type";
    private static final String TEST_DATA = "\"TEST_DATA\"";
    private static final String TEST_EXECUTION_ID = "test-kogito-execution-id";
    private static final String TEST_DMN_MODEL_NAME = "test-kogito-dmn-model-name";
    private static final String TEST_DMN_MODEL_NAMESPACE = "test-kogito-dmn-model-namespace";
    private static final String TEST_DMN_EVALUATE_DECISION = "test-kogito-dmn-eval-decision";

    @BeforeAll
    static void registerExtension() {
        KogitoExtension.register();
    }

    @Test
    void writeExtension() {
        this.assertWriteExtension(null, null, null, null);
        this.assertWriteExtension(null, null, null, false);
        this.assertWriteExtension(null, null, null, true);
        this.assertWriteExtension(null, null, false, null);
        this.assertWriteExtension(null, null, false, false);
        this.assertWriteExtension(null, null, false, true);
        this.assertWriteExtension(null, null, true, null);
        this.assertWriteExtension(null, null, true, false);
        this.assertWriteExtension(null, null, true, true);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, null, null);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, null, false);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, null, true);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, false, null);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, false, false);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, false, true);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, true, null);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, true, false);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, true, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, null, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, null, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, null, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, false, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, false, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, false, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, true, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, true, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, true, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, true);
    }

    private void assertWriteExtension(String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        CloudEvent event = this.cloudEventFromExtensionObject(dmnEvaluateDecision, executionId, dmnFullResult, dmnFilteredCtx);
        this.assertCloudEvent(event, dmnEvaluateDecision, executionId, dmnFullResult, dmnFilteredCtx);
    }

    @Test
    void parseExtension() {
        this.assertParseExtension(null, null, null, null);
        this.assertParseExtension(null, null, null, false);
        this.assertParseExtension(null, null, null, true);
        this.assertParseExtension(null, null, false, null);
        this.assertParseExtension(null, null, false, false);
        this.assertParseExtension(null, null, false, true);
        this.assertParseExtension(null, null, true, null);
        this.assertParseExtension(null, null, true, false);
        this.assertParseExtension(null, null, true, true);
        this.assertParseExtension(null, TEST_EXECUTION_ID, null, null);
        this.assertParseExtension(null, TEST_EXECUTION_ID, null, false);
        this.assertParseExtension(null, TEST_EXECUTION_ID, null, true);
        this.assertParseExtension(null, TEST_EXECUTION_ID, false, null);
        this.assertParseExtension(null, TEST_EXECUTION_ID, false, false);
        this.assertParseExtension(null, TEST_EXECUTION_ID, false, true);
        this.assertParseExtension(null, TEST_EXECUTION_ID, true, null);
        this.assertParseExtension(null, TEST_EXECUTION_ID, true, false);
        this.assertParseExtension(null, TEST_EXECUTION_ID, true, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, null, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, null, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, null, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, false, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, false, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, false, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, true, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, true, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, true, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, true);
    }

    private void assertParseExtension(String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        KogitoExtension extension = this.extensionObjectFromCloudEvent(dmnEvaluateDecision, executionId, dmnFullResult, dmnFilteredCtx);
        this.assertExtension(extension, dmnEvaluateDecision, executionId, dmnFullResult, dmnFilteredCtx);
    }

    @Test
    void writeAndParseExtensionWithEncoding() {
        this.assertWriteAndParseExtensionWithEncoding(null, null, null, null);
        this.assertWriteAndParseExtensionWithEncoding(null, null, null, false);
        this.assertWriteAndParseExtensionWithEncoding(null, null, null, true);
        this.assertWriteAndParseExtensionWithEncoding(null, null, false, null);
        this.assertWriteAndParseExtensionWithEncoding(null, null, false, false);
        this.assertWriteAndParseExtensionWithEncoding(null, null, false, true);
        this.assertWriteAndParseExtensionWithEncoding(null, null, true, null);
        this.assertWriteAndParseExtensionWithEncoding(null, null, true, false);
        this.assertWriteAndParseExtensionWithEncoding(null, null, true, true);
        this.assertWriteAndParseExtensionWithEncoding(null, TEST_EXECUTION_ID, null, null);
        this.assertWriteAndParseExtensionWithEncoding(null, TEST_EXECUTION_ID, null, false);
        this.assertWriteAndParseExtensionWithEncoding(null, TEST_EXECUTION_ID, null, true);
        this.assertWriteAndParseExtensionWithEncoding(null, TEST_EXECUTION_ID, false, null);
        this.assertWriteAndParseExtensionWithEncoding(null, TEST_EXECUTION_ID, false, false);
        this.assertWriteAndParseExtensionWithEncoding(null, TEST_EXECUTION_ID, false, true);
        this.assertWriteAndParseExtensionWithEncoding(null, TEST_EXECUTION_ID, true, null);
        this.assertWriteAndParseExtensionWithEncoding(null, TEST_EXECUTION_ID, true, false);
        this.assertWriteAndParseExtensionWithEncoding(null, TEST_EXECUTION_ID, true, true);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, null, null, null);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, null, null, false);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, null, null, true);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, null, false, null);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, null, false, false);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, null, false, true);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, null, true, null);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, null, true, false);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, null, true, true);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, null);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, false);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, true);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, null);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, false);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, true);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, null);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, false);
        this.assertWriteAndParseExtensionWithEncoding(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, true);
    }

    private void assertWriteAndParseExtensionWithEncoding(String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        CloudEvent inputEvent = this.cloudEventFromExtensionObject(dmnEvaluateDecision, executionId, dmnFullResult, dmnFilteredCtx);
        String inputEventJson = (String)CloudEventUtils.encode((CloudEvent)inputEvent).orElseThrow(IllegalStateException::new);
        CloudEvent outputEvent = (CloudEvent)CloudEventUtils.decode((String)inputEventJson).orElseThrow(IllegalStateException::new);
        KogitoExtension outputKogitoExt = (KogitoExtension)ExtensionProvider.getInstance().parseExtension(KogitoExtension.class, (CloudEventExtensions)outputEvent);
        this.assertExtension(outputKogitoExt, dmnEvaluateDecision, executionId, dmnFullResult, dmnFilteredCtx);
    }

    private CloudEvent cloudEventFromExtensionObject(String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        KogitoExtension kogitoExt = new KogitoExtension();
        kogitoExt.setDmnModelName(TEST_DMN_MODEL_NAME);
        kogitoExt.setDmnModelNamespace(TEST_DMN_MODEL_NAMESPACE);
        if (dmnEvaluateDecision != null) {
            kogitoExt.setDmnEvaluateDecision(dmnEvaluateDecision);
        }
        if (executionId != null) {
            kogitoExt.setExecutionId(executionId);
        }
        if (dmnFullResult != null) {
            kogitoExt.setDmnFullResult(dmnFullResult);
        }
        if (dmnFilteredCtx != null) {
            kogitoExt.setDmnFilteredCtx(dmnFilteredCtx);
        }
        return ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(TEST_ID).withSource(URI.create(TEST_SOURCE)).withType(TEST_TYPE).withData(TEST_DATA.getBytes())).withExtension((CloudEventExtension)kogitoExt)).build();
    }

    private void assertCloudEvent(CloudEvent event, String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        Assertions.assertNotNull((Object)event);
        Assertions.assertEquals((Object)TEST_DMN_MODEL_NAME, (Object)event.getExtension("kogitodmnmodelname"));
        Assertions.assertEquals((Object)TEST_DMN_MODEL_NAMESPACE, (Object)event.getExtension("kogitodmnmodelnamespace"));
        Assertions.assertEquals((Object)dmnEvaluateDecision, (Object)event.getExtension("kogitodmnevaldecision"));
        Assertions.assertEquals((Object)executionId, (Object)event.getExtension("kogitoexecutionid"));
        Assertions.assertEquals((Object)dmnFullResult, (Object)event.getExtension("kogitodmnfullresult"));
        Assertions.assertEquals((Object)dmnFilteredCtx, (Object)event.getExtension("kogitodmnfilteredctx"));
    }

    private KogitoExtension extensionObjectFromCloudEvent(String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        BaseCloudEventBuilder builder = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(TEST_ID).withSource(URI.create(TEST_SOURCE)).withType(TEST_TYPE).withData(TEST_DATA.getBytes())).withExtension("kogitodmnmodelname", TEST_DMN_MODEL_NAME)).withExtension("kogitodmnmodelnamespace", TEST_DMN_MODEL_NAMESPACE);
        if (dmnEvaluateDecision != null) {
            builder.withExtension("kogitodmnevaldecision", dmnEvaluateDecision);
        }
        if (executionId != null) {
            builder.withExtension("kogitoexecutionid", executionId);
        }
        if (dmnFullResult != null) {
            builder.withExtension("kogitodmnfullresult", dmnFullResult);
        }
        if (dmnFilteredCtx != null) {
            builder.withExtension("kogitodmnfilteredctx", dmnFilteredCtx);
        }
        return (KogitoExtension)ExtensionProvider.getInstance().parseExtension(KogitoExtension.class, (CloudEventExtensions)builder.build());
    }

    private void assertExtension(KogitoExtension kogitoExtension, String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        Assertions.assertNotNull((Object)kogitoExtension);
        Assertions.assertEquals((Object)TEST_DMN_MODEL_NAME, (Object)kogitoExtension.getDmnModelName());
        Assertions.assertEquals((Object)TEST_DMN_MODEL_NAMESPACE, (Object)kogitoExtension.getDmnModelNamespace());
        Assertions.assertEquals((Object)dmnEvaluateDecision, (Object)kogitoExtension.getDmnEvaluateDecision());
        Assertions.assertEquals((Object)executionId, (Object)kogitoExtension.getExecutionId());
        Assertions.assertSame((Object)dmnFullResult, (Object)kogitoExtension.isDmnFullResult());
        Assertions.assertSame((Object)dmnFilteredCtx, (Object)kogitoExtension.isDmnFilteredCtx());
    }
}

