/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.eventdriven.decision;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.provider.ExtensionProvider;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;
import org.kie.kogito.cloudevents.CloudEventUtils;
import org.kie.kogito.cloudevents.extension.KogitoExtension;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.decision.DecisionExecutionIdUtils;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.rest.DMNJSONUtils;
import org.kie.kogito.dmn.rest.KogitoDMNResult;
import org.kie.kogito.event.EventConverter;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.SubscriptionInfo;
import org.kie.kogito.eventdriven.decision.DecisionResponseError;
import org.kie.kogito.services.event.impl.JsonStringToObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDrivenDecisionController {
    public static final String REQUEST_EVENT_TYPE = "DecisionRequest";
    public static final String RESPONSE_EVENT_TYPE = "DecisionResponse";
    public static final String RESPONSE_FULL_EVENT_TYPE = "DecisionResponseFull";
    public static final String RESPONSE_ERROR_EVENT_TYPE = "DecisionResponseError";
    private static final Logger LOG = LoggerFactory.getLogger(EventDrivenDecisionController.class);
    private DecisionModels decisionModels;
    private ConfigBean config;
    private EventEmitter eventEmitter;
    private EventReceiver eventReceiver;

    protected EventDrivenDecisionController() {
    }

    protected EventDrivenDecisionController(DecisionModels decisionModels, ConfigBean config, EventEmitter eventEmitter, EventReceiver eventReceiver) {
        this.decisionModels = decisionModels;
        this.config = config;
        this.eventEmitter = eventEmitter;
        this.eventReceiver = eventReceiver;
    }

    protected void init(DecisionModels decisionModels, ConfigBean config, EventEmitter eventEmitter, EventReceiver eventReceiver) {
        this.decisionModels = decisionModels;
        this.config = config;
        this.eventEmitter = eventEmitter;
        this.eventReceiver = eventReceiver;
    }

    protected void subscribe() {
        this.eventReceiver.subscribe(this::handleRequest, new SubscriptionInfo((EventConverter)new JsonStringToObject(CloudEventUtils.Mapper.mapper()), CloudEvent.class));
    }

    private CompletionStage<Void> handleRequest(CloudEvent event) {
        this.validateRequest(event).flatMap(this::buildEvaluationContext).map(this::processRequest).flatMap(this::buildResponseCloudEvent).flatMap(CloudEventUtils::toDataEvent).ifPresent(e -> this.eventEmitter.emit(e, (String)e.get("type"), Optional.empty()));
        return CompletableFuture.completedFuture(null);
    }

    private Optional<CloudEvent> validateRequest(CloudEvent event) {
        return Optional.ofNullable(event).filter(e -> REQUEST_EVENT_TYPE.equals(e.getType()));
    }

    private Optional<EvaluationContext> buildEvaluationContext(CloudEvent event) {
        KogitoExtension kogitoExtension = (KogitoExtension)ExtensionProvider.getInstance().parseExtension(KogitoExtension.class, (CloudEventExtensions)event);
        Map data = CloudEventUtils.decodeMapData((CloudEvent)event, String.class, Object.class).orElse(null);
        if (kogitoExtension == null) {
            LOG.warn("Received CloudEvent(id={} source={} type={}) with null Kogito extension", new Object[]{event.getId(), event.getSource(), event.getType()});
        }
        if (data == null) {
            LOG.warn("Received CloudEvent(id={} source={} type={}) with null data", new Object[]{event.getId(), event.getSource(), event.getType()});
        }
        return Optional.of(new EvaluationContext(event, kogitoExtension, data));
    }

    private EvaluationContext processRequest(EvaluationContext ctx) {
        if (!ctx.isValidRequest()) {
            ctx.setResponseError(DecisionResponseError.BAD_REQUEST);
            return ctx;
        }
        Optional<DecisionModel> optDecisionModel = this.getDecisionModel(ctx.getRequestModelNamespace(), ctx.getRequestModelName());
        if (!optDecisionModel.isPresent()) {
            ctx.setResponseError(DecisionResponseError.MODEL_NOT_FOUND);
            return ctx;
        }
        DecisionModel model = optDecisionModel.get();
        DMNContext context = DMNJSONUtils.ctx((DecisionModel)model, ctx.getRequestData());
        DMNResult apiResult = ctx.isEvaluateDecisionServiceRequest() ? model.evaluateDecisionService(context, ctx.getRequestDecisionServiceToEvaluate()) : model.evaluateAll(context);
        ctx.setResponseDmnResult(apiResult);
        return ctx;
    }

    private Optional<DecisionModel> getDecisionModel(String modelNamespace, String modelName) {
        try {
            return Optional.ofNullable(this.decisionModels.getDecisionModel(modelNamespace, modelName));
        }
        catch (IllegalStateException e) {
            LOG.warn("Model not found with name=\"{}\" namespace=\"{}\"", (Object)modelName, (Object)modelNamespace);
            return Optional.empty();
        }
    }

    private Optional<CloudEvent> buildResponseCloudEvent(EvaluationContext ctx) {
        String id = UUID.randomUUID().toString();
        URI source = this.buildResponseCloudEventSource(ctx);
        String subject = ctx.getRequestCloudEvent().getSubject();
        KogitoExtension kogitoExtension = new KogitoExtension();
        kogitoExtension.setDmnModelName(ctx.getRequestModelName());
        kogitoExtension.setDmnModelNamespace(ctx.getRequestModelNamespace());
        kogitoExtension.setDmnEvaluateDecision(ctx.getRequestDecisionServiceToEvaluate());
        if (ctx.isResponseError()) {
            String data = Optional.ofNullable(ctx.getResponseError()).map(Enum::name).orElse(null);
            return CloudEventUtils.build((String)id, (URI)source, (String)RESPONSE_ERROR_EVENT_TYPE, (String)subject, (Object)data, (CloudEventExtension[])new CloudEventExtension[]{kogitoExtension});
        }
        kogitoExtension.setExecutionId(DecisionExecutionIdUtils.get((DMNContext)ctx.getResponseDmnResult().getContext()));
        KogitoDMNResult restResult = new KogitoDMNResult(ctx.getRequestModelNamespace(), ctx.getRequestModelName(), ctx.getResponseDmnResult());
        if (ctx.isRequestFullResult()) {
            if (ctx.isRequestFilteredContext()) {
                restResult.setDmnContext(this.filterContext(restResult.getDmnContext(), ctx.requestData));
            }
            return CloudEventUtils.build((String)id, (URI)source, (String)RESPONSE_FULL_EVENT_TYPE, (String)subject, (Object)restResult, (CloudEventExtension[])new CloudEventExtension[]{kogitoExtension});
        }
        Map<String, Object> data = ctx.isRequestFilteredContext() ? this.filterContext(restResult.getDmnContext(), ctx.requestData) : restResult.getDmnContext();
        return CloudEventUtils.build((String)id, (URI)source, (String)RESPONSE_EVENT_TYPE, (String)subject, data, (CloudEventExtension[])new CloudEventExtension[]{kogitoExtension});
    }

    private Map<String, Object> filterContext(Map<String, Object> values, Map<String, Object> inputs) {
        return values.entrySet().stream().filter(entry -> !inputs.containsKey(entry.getKey())).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
    }

    private URI buildResponseCloudEventSource(EvaluationContext ctx) {
        return ctx.isEvaluateDecisionServiceRequest() ? CloudEventUtils.buildDecisionSource((String)this.config.getServiceUrl(), (String)ctx.getRequestModelName(), (String)ctx.getRequestDecisionServiceToEvaluate()) : CloudEventUtils.buildDecisionSource((String)this.config.getServiceUrl(), (String)ctx.getRequestModelName());
    }

    private static class EvaluationContext {
        private final CloudEvent requestCloudEvent;
        private final Map<String, Object> requestData;
        private final String requestModelName;
        private final String requestModelNamespace;
        private final String requestDecisionServiceToEvaluate;
        private final boolean requestFullResult;
        private final boolean requestFilteredContext;
        private final boolean validRequest;
        private final boolean evaluateDecisionServiceRequest;
        private DecisionResponseError responseError;
        private DMNResult responseDmnResult;

        public EvaluationContext(CloudEvent requestCloudEvent, KogitoExtension requestKogitoExtension, Map<String, Object> requestData) {
            this.requestCloudEvent = requestCloudEvent;
            this.requestData = requestData;
            this.requestModelName = Optional.ofNullable(requestKogitoExtension).map(KogitoExtension::getDmnModelName).orElse(null);
            this.requestModelNamespace = Optional.ofNullable(requestKogitoExtension).map(KogitoExtension::getDmnModelNamespace).orElse(null);
            this.requestDecisionServiceToEvaluate = Optional.ofNullable(requestKogitoExtension).map(KogitoExtension::getDmnEvaluateDecision).orElse(null);
            this.requestFullResult = Optional.ofNullable(requestKogitoExtension).map(KogitoExtension::isDmnFullResult).orElse(false);
            this.requestFilteredContext = Optional.ofNullable(requestKogitoExtension).map(KogitoExtension::isDmnFilteredCtx).orElse(false);
            this.validRequest = requestCloudEvent != null && requestKogitoExtension != null && this.requestModelName != null && !this.requestModelName.isEmpty() && this.requestModelNamespace != null && !this.requestModelNamespace.isEmpty() && requestData != null;
            this.evaluateDecisionServiceRequest = this.validRequest && this.requestDecisionServiceToEvaluate != null && !this.requestDecisionServiceToEvaluate.isEmpty();
        }

        public boolean isValidRequest() {
            return this.validRequest;
        }

        public boolean isEvaluateDecisionServiceRequest() {
            return this.evaluateDecisionServiceRequest;
        }

        public CloudEvent getRequestCloudEvent() {
            return this.requestCloudEvent;
        }

        public Map<String, Object> getRequestData() {
            return this.requestData;
        }

        String getRequestModelName() {
            return this.requestModelName;
        }

        String getRequestModelNamespace() {
            return this.requestModelNamespace;
        }

        String getRequestDecisionServiceToEvaluate() {
            return this.requestDecisionServiceToEvaluate;
        }

        public boolean isRequestFullResult() {
            return this.requestFullResult;
        }

        public boolean isRequestFilteredContext() {
            return this.requestFilteredContext;
        }

        boolean isResponseError() {
            return this.responseDmnResult == null;
        }

        public DecisionResponseError getResponseError() {
            return this.responseError;
        }

        public void setResponseError(DecisionResponseError responseError) {
            this.responseError = responseError;
        }

        public DMNResult getResponseDmnResult() {
            return this.responseDmnResult;
        }

        public void setResponseDmnResult(DMNResult responseDmnResult) {
            this.responseDmnResult = responseDmnResult;
        }
    }
}

