/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.eventdriven.decision;

import io.cloudevents.CloudEventExtension;
import io.cloudevents.core.provider.ExtensionProvider;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;
import org.kie.kogito.config.ConfigBean;
import org.kie.kogito.decision.DecisionExecutionIdUtils;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.rest.DMNJSONUtils;
import org.kie.kogito.dmn.rest.KogitoDMNResult;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.DataEventFactory;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.cloudevents.extension.KogitoExtension;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.internal.utils.ConversionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDrivenDecisionController {
    public static final String REQUEST_EVENT_TYPE = "DecisionRequest";
    public static final String RESPONSE_EVENT_TYPE = "DecisionResponse";
    public static final String RESPONSE_FULL_EVENT_TYPE = "DecisionResponseFull";
    private static final Logger LOG = LoggerFactory.getLogger(EventDrivenDecisionController.class);
    private DecisionModels decisionModels;
    private ConfigBean config;
    private EventEmitter eventEmitter;
    private EventReceiver eventReceiver;

    protected EventDrivenDecisionController() {
    }

    protected EventDrivenDecisionController(DecisionModels decisionModels, ConfigBean config, EventEmitter eventEmitter, EventReceiver eventReceiver) {
        this.init(decisionModels, config, eventEmitter, eventReceiver);
    }

    protected void init(DecisionModels decisionModels, ConfigBean config, EventEmitter eventEmitter, EventReceiver eventReceiver) {
        this.decisionModels = decisionModels;
        this.config = config;
        this.eventEmitter = eventEmitter;
        this.eventReceiver = eventReceiver;
    }

    protected void subscribe() {
        this.eventReceiver.subscribe(this::handleRequest, Map.class);
    }

    private CompletionStage<Void> handleRequest(DataEvent<Map> event) {
        KogitoExtension kogitoExtension = (KogitoExtension)ExtensionProvider.getInstance().parseExtension(KogitoExtension.class, event);
        if (CloudEventUtils.isValidRequest(event, (String)REQUEST_EVENT_TYPE, (CloudEventExtension)kogitoExtension)) {
            this.getDecisionModel(kogitoExtension.getDmnModelNamespace(), kogitoExtension.getDmnModelName()).map(model -> this.processRequest((DecisionModel)model, event, kogitoExtension)).ifPresentOrElse(result -> this.eventEmitter.emit(this.buildResponseEvent((DMNResult)result, event, kogitoExtension)), () -> LOG.warn("Discarding request because not model is found for {}", (Object)kogitoExtension));
        } else {
            LOG.warn("Event {} is not valid. Ignoring it", event);
        }
        return CompletableFuture.completedFuture(null);
    }

    private DataEvent<?> buildResponseEvent(DMNResult result, DataEvent<Map> srcEvent, KogitoExtension extension) {
        URI source = this.buildResponseCloudEventSource(extension);
        Optional<String> subject = Optional.ofNullable(srcEvent.getSubject());
        KogitoExtension publishedExtension = EventDrivenDecisionController.publishedExtension(extension, result);
        KogitoDMNResult restResult = new KogitoDMNResult(extension.getDmnModelNamespace(), extension.getDmnModelName(), result);
        if (CloudEventUtils.safeBoolean((Boolean)extension.isDmnFilteredCtx())) {
            restResult.getDmnContext().keySet().removeAll(((Map)srcEvent.getData()).keySet());
        }
        return CloudEventUtils.safeBoolean((Boolean)extension.isDmnFullResult()) ? DataEventFactory.from((Object)restResult, (String)RESPONSE_FULL_EVENT_TYPE, (URI)source, subject, (CloudEventExtension[])new CloudEventExtension[]{publishedExtension}) : DataEventFactory.from((Object)restResult.getDmnContext(), (String)RESPONSE_EVENT_TYPE, (URI)source, subject, (CloudEventExtension[])new CloudEventExtension[]{publishedExtension});
    }

    private DMNResult processRequest(DecisionModel model, DataEvent<Map> event, KogitoExtension kogitoExtension) {
        DMNContext context = DMNJSONUtils.ctx((DecisionModel)model, (Map)((Map)event.getData()));
        return ConversionUtils.isEmpty((String)kogitoExtension.getDmnEvaluateDecision()) ? model.evaluateAll(context) : model.evaluateDecisionService(context, kogitoExtension.getDmnEvaluateDecision());
    }

    private Optional<DecisionModel> getDecisionModel(String modelNamespace, String modelName) {
        try {
            return Optional.ofNullable(this.decisionModels.getDecisionModel(modelNamespace, modelName));
        }
        catch (IllegalStateException e) {
            LOG.warn("Model not found with name=\"{}\" namespace=\"{}\"", (Object)modelName, (Object)modelNamespace);
            return Optional.empty();
        }
    }

    private static KogitoExtension publishedExtension(KogitoExtension extension, DMNResult result) {
        KogitoExtension published = new KogitoExtension();
        published.setExecutionId(DecisionExecutionIdUtils.get((DMNContext)result.getContext()));
        published.setDmnModelName(extension.getDmnModelName());
        published.setDmnModelNamespace(extension.getDmnModelNamespace());
        published.setDmnEvaluateDecision(extension.getDmnEvaluateDecision());
        return published;
    }

    private URI buildResponseCloudEventSource(KogitoExtension ctx) {
        return ConversionUtils.isEmpty((String)ctx.getDmnEvaluateDecision()) ? CloudEventUtils.buildDecisionSource((String)this.config.getServiceUrl(), (String)ctx.getDmnModelName()) : CloudEventUtils.buildDecisionSource((String)this.config.getServiceUrl(), (String)ctx.getDmnModelName(), (String)ctx.getDmnEvaluateDecision());
    }
}

