/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.eventdriven.decision;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.provider.ExtensionProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.kogito.config.ConfigBean;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.DecisionTestUtils;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.kie.kogito.dmn.rest.KogitoDMNResult;
import org.kie.kogito.event.CloudEventUnmarshallerFactory;
import org.kie.kogito.event.Converter;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.Subscription;
import org.kie.kogito.event.cloudevents.extension.KogitoExtension;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.event.impl.CloudEventConverter;
import org.kie.kogito.event.impl.ObjectCloudEventUnmarshallerFactory;
import org.kie.kogito.eventdriven.decision.EventDrivenDecisionController;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class EventDrivenDecisionControllerTest {
    private static final String MODEL_NAME_PLACEHOLDER = "%%MODEL_NAME%%";
    private static final String MODEL_NAMESPACE_PLACEHOLDER = "%%MODEL_NAMESPACE%%";
    private static final String EVALUATE_DECISION_PLACEHOLDER = "%%EVALUATE_DECISION%%";
    private static final String FULL_RESULT_PLACEHOLDER = "%%FULL_RESULT%%";
    private static final String FILTERED_CTX_PLACEHOLDER = "%%FILTERED_CTX%%";
    private static final String DATA_PLACEHOLDER = "%%DATA%%";
    private static final String CLOUDEVENT_ID = "a89b61a2-5644-487a-8a86-144855c5dce8";
    private static final String CLOUDEVENT_SOURCE = "SomeEventSource";
    private static final String CLOUDEVENT_SUBJECT = "TheSubject";
    private static final String CLOUDEVENT_TEMPLATE = "{\n    \"specversion\": \"1.0\",\n    \"id\": \"a89b61a2-5644-487a-8a86-144855c5dce8\",\n    \"source\": \"SomeEventSource\",\n    \"type\": \"DecisionRequest\",\n    \"subject\": \"TheSubject\",\n    \"kogitodmnmodelname\": %%MODEL_NAME%%,\n    \"kogitodmnmodelnamespace\": %%MODEL_NAMESPACE%%,\n    \"kogitodmnevaldecision\": %%EVALUATE_DECISION%%,\n    \"kogitodmnfullresult\": %%FULL_RESULT%%,\n    \"kogitodmnfilteredctx\": %%FILTERED_CTX%%,\n    \"data\": %%DATA%%\n}";
    private static final String CLOUDEVENT_IGNORED = "{\n    \"specversion\": \"1.0\",\n    \"id\": \"55c5dce8-5644-487a-8a86-1448a89b61a2\",\n    \"source\": \"SomeOtherEventSource\",\n    \"type\": \"SomeType\",\n    \"data\": {}\n}";
    private static final RequestData REQUEST_DATA_EVALUATE_ALL = new RequestData("Traffic Violation", "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", null, "{\n    \"Driver\": {\n        \"Age\": 25,\n        \"Points\": 13\n    },\n    \"Violation\": {\n        \"Type\": \"speed\",\n        \"Actual Speed\": 115,\n        \"Speed Limit\": 100\n    }\n}");
    private static final RequestData REQUEST_DATA_EVALUATE_DECISION_SERVICE = new RequestData("Traffic Violation", "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "FineService", "{\n    \"Violation\": {\n        \"Type\": \"speed\",\n        \"Actual Speed\": 115,\n        \"Speed Limit\": 100\n    }\n}");
    private static final String TEST_EXECUTION_ID = "11ecbb6f-fb25-4597-88c8-ac7976efe078";
    private static DMNRuntime runtime;
    private static final ObjectMapper objectMapper;
    private EventDrivenDecisionController controller;
    private TestEventReceiver testEventReceiver;
    private EventEmitter eventEmitterMock;
    private DecisionModel decisionModelSpy;
    private DecisionModels decisionModelsMock;

    EventDrivenDecisionControllerTest() {
    }

    @BeforeAll
    static void beforeAll() {
        ExtensionProvider.getInstance().registerExtension(KogitoExtension.class, KogitoExtension::new);
        runtime = DecisionTestUtils.createDMNRuntime();
    }

    @BeforeEach
    void beforeEach() {
        this.testEventReceiver = new TestEventReceiver();
        this.decisionModelsMock = (DecisionModels)Mockito.mock(DecisionModels.class);
        this.eventEmitterMock = (EventEmitter)Mockito.mock(EventEmitter.class);
        this.mockDecisionModel();
        this.controller = new EventDrivenDecisionController(this.decisionModelsMock, (ConfigBean)Mockito.mock(ConfigBean.class), this.eventEmitterMock, (EventReceiver)this.testEventReceiver);
        this.controller.subscribe();
    }

    @Test
    void testSubscribe() {
        DecisionModels decisionModelsMock = (DecisionModels)Mockito.mock(DecisionModels.class);
        ConfigBean configMock = (ConfigBean)Mockito.mock(ConfigBean.class);
        EventEmitter eventEmitterMock = (EventEmitter)Mockito.mock(EventEmitter.class);
        EventReceiver eventReceiverMock = (EventReceiver)Mockito.mock(EventReceiver.class);
        EventDrivenDecisionController controller1 = new EventDrivenDecisionController(decisionModelsMock, configMock, eventEmitterMock, eventReceiverMock);
        controller1.subscribe();
        ((EventReceiver)Mockito.verify((Object)eventReceiverMock)).subscribe((Function)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        Mockito.reset((Object[])new EventReceiver[]{eventReceiverMock});
        EventDrivenDecisionController controller2 = new EventDrivenDecisionController();
        controller2.init(decisionModelsMock, configMock, eventEmitterMock, eventReceiverMock);
        controller2.subscribe();
        ((EventReceiver)Mockito.verify((Object)eventReceiverMock)).subscribe((Function)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
    }

    @Test
    void testHandleEventWithIgnoredCloudEvent() throws IOException {
        this.testEventReceiver.accept(CLOUDEVENT_IGNORED);
        ((EventEmitter)Mockito.verify((Object)this.eventEmitterMock, (VerificationMode)Mockito.never())).emit((DataEvent)ArgumentMatchers.any());
    }

    @Test
    void testHandleEventWithValidCloudEventProducingOkEvaluateAll() throws IOException {
        this.testAllDefaultAndFullCloudEventEmittedCombinations(REQUEST_DATA_EVALUATE_ALL, kogitoExtension -> {
            Assertions.assertThat((String)kogitoExtension.getExecutionId()).isNull();
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy)).evaluateAll((DMNContext)ArgumentMatchers.notNull());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy, (VerificationMode)Mockito.never())).evaluateDecisionService((DMNContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
            Mockito.clearInvocations((Object[])new DecisionModel[]{this.decisionModelSpy});
        });
    }

    @Test
    void testHandleEventWithValidCloudEventWithExecutionIdProducingOkEvaluateAll() throws IOException {
        this.mockDecisionModelWithExecutionIdSupplier();
        this.testAllDefaultAndFullCloudEventEmittedCombinations(REQUEST_DATA_EVALUATE_ALL, kogitoExtension -> {
            Assertions.assertThat((String)kogitoExtension.getExecutionId()).isEqualTo(TEST_EXECUTION_ID);
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy)).evaluateAll((DMNContext)ArgumentMatchers.notNull());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy, (VerificationMode)Mockito.never())).evaluateDecisionService((DMNContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
            Mockito.clearInvocations((Object[])new DecisionModel[]{this.decisionModelSpy});
        });
    }

    @Test
    void testHandleEventWithValidCloudEventProducingOkEvaluateDecisionService() throws IOException {
        this.testAllDefaultAndFullCloudEventEmittedCombinations(REQUEST_DATA_EVALUATE_DECISION_SERVICE, kogitoExtension -> {
            Assertions.assertThat((String)kogitoExtension.getExecutionId()).isNull();
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy, (VerificationMode)Mockito.never())).evaluateAll((DMNContext)ArgumentMatchers.any());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy)).evaluateDecisionService((DMNContext)ArgumentMatchers.notNull(), (String)ArgumentMatchers.notNull());
            Mockito.clearInvocations((Object[])new DecisionModel[]{this.decisionModelSpy});
        });
    }

    @Test
    void testHandleEventWithValidCloudEventWithExecutionIdProducingOkEvaluateDecisionService() throws IOException {
        this.mockDecisionModelWithExecutionIdSupplier();
        this.testAllDefaultAndFullCloudEventEmittedCombinations(REQUEST_DATA_EVALUATE_DECISION_SERVICE, kogitoExtension -> {
            Assertions.assertThat((String)kogitoExtension.getExecutionId()).isEqualTo(TEST_EXECUTION_ID);
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy, (VerificationMode)Mockito.never())).evaluateAll((DMNContext)ArgumentMatchers.any());
            ((DecisionModel)Mockito.verify((Object)this.decisionModelSpy)).evaluateDecisionService((DMNContext)ArgumentMatchers.notNull(), (String)ArgumentMatchers.notNull());
            Mockito.clearInvocations((Object[])new DecisionModel[]{this.decisionModelSpy});
        });
    }

    private void assertSubject(DataEvent<?> event) {
        ((AbstractStringAssert)Assertions.assertThat((String)event.getSubject()).isNotNull()).isEqualTo(CLOUDEVENT_SUBJECT);
    }

    private String cloudEventOkWith(RequestData requestData, Boolean fullResult, Boolean filteredCtx) {
        return CLOUDEVENT_TEMPLATE.replace(MODEL_NAME_PLACEHOLDER, this.format(requestData.getModelName())).replace(MODEL_NAMESPACE_PLACEHOLDER, this.format(requestData.getModelNamespace())).replace(EVALUATE_DECISION_PLACEHOLDER, this.format(requestData.getDecision())).replace(FULL_RESULT_PLACEHOLDER, fullResult == null ? "null" : fullResult.toString()).replace(FILTERED_CTX_PLACEHOLDER, filteredCtx == null ? "null" : filteredCtx.toString()).replace(DATA_PLACEHOLDER, Optional.ofNullable(requestData.getData()).orElse("null"));
    }

    private String format(String input) {
        return Optional.ofNullable(input).map(i -> "\"" + i + "\"").orElse("null");
    }

    private void mockDecisionModel() {
        this.decisionModelSpy = (DecisionModel)Mockito.spy((Object)new DmnDecisionModel(runtime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation"));
        Mockito.when((Object)this.decisionModelsMock.getDecisionModel((String)ArgumentMatchers.eq((Object)"https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF"), (String)ArgumentMatchers.eq((Object)"Traffic Violation"))).thenReturn((Object)this.decisionModelSpy);
    }

    private void mockDecisionModelWithExecutionIdSupplier() {
        this.decisionModelSpy = (DecisionModel)Mockito.spy((Object)new DmnDecisionModel(runtime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", () -> TEST_EXECUTION_ID));
        Mockito.when((Object)this.decisionModelsMock.getDecisionModel((String)ArgumentMatchers.eq((Object)"https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF"), (String)ArgumentMatchers.eq((Object)"Traffic Violation"))).thenReturn((Object)this.decisionModelSpy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void testCloudEventEmitted(RequestData requestData, Boolean fullResult, Boolean filteredCtx, Class<T> responseDataClass, String expectedType, TriConsumer<DataEvent<T>, KogitoExtension, T> callback) throws IOException {
        try {
            ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(DataEvent.class);
            String inputEvent = this.cloudEventOkWith(requestData, fullResult, filteredCtx);
            this.testEventReceiver.accept(inputEvent);
            ((EventEmitter)Mockito.verify((Object)this.eventEmitterMock)).emit((DataEvent)eventCaptor.capture());
            DataEvent emittedCloudEvent = (DataEvent)eventCaptor.getValue();
            Assertions.assertThat((String)emittedCloudEvent.getType()).isEqualTo(expectedType);
            KogitoExtension kogitoExtension = (KogitoExtension)ExtensionProvider.getInstance().parseExtension(KogitoExtension.class, (CloudEventExtensions)emittedCloudEvent);
            if (kogitoExtension == null) {
                Assertions.fail((String)("No Kogito extension in emitted CloudEvent: " + emittedCloudEvent));
            }
            Assertions.assertThat((String)kogitoExtension.getDmnModelName()).isEqualTo(requestData.getModelName());
            Assertions.assertThat((String)kogitoExtension.getDmnModelNamespace()).isEqualTo(requestData.getModelNamespace());
            Assertions.assertThat((String)kogitoExtension.getDmnEvaluateDecision()).isEqualTo(requestData.getDecision());
            this.assertSubject(emittedCloudEvent);
            if (callback != null) {
                callback.accept((DataEvent<DataEvent>)emittedCloudEvent, kogitoExtension, (DataEvent)emittedCloudEvent.getData());
            }
        }
        catch (Throwable throwable) {
            Mockito.reset((Object[])new EventEmitter[]{this.eventEmitterMock});
            throw throwable;
        }
        Mockito.reset((Object[])new EventEmitter[]{this.eventEmitterMock});
    }

    private void testDefaultCloudEventEmitted(RequestData requestData, Boolean fullResult, Boolean filteredCtx, Consumer<KogitoExtension> callback) throws IOException {
        this.testCloudEventEmitted(requestData, fullResult, filteredCtx, Map.class, "DecisionResponse", (cloudEvent, kogitoExtension, data) -> callback.accept((KogitoExtension)kogitoExtension));
    }

    private void testFullCloudEventEmitted(RequestData requestData, Boolean fullResult, Boolean filteredCtx, Consumer<KogitoExtension> callback) throws IOException {
        this.testCloudEventEmitted(requestData, fullResult, filteredCtx, KogitoDMNResult.class, "DecisionResponseFull", (cloudEvent, kogitoExtension, data) -> {
            Assertions.assertThat((String)data.getNamespace()).isNotNull();
            Assertions.assertThat((String)data.getModelName()).isNotNull();
            Assertions.assertThat((Map)data.getDmnContext()).isNotNull();
            Assertions.assertThat((List)data.getMessages()).isNotNull();
            Assertions.assertThat((List)data.getDecisionResults()).isNotNull();
            callback.accept((KogitoExtension)kogitoExtension);
        });
    }

    private void testAllDefaultAndFullCloudEventEmittedCombinations(RequestData requestData, Consumer<KogitoExtension> consumer) throws IOException {
        this.testDefaultCloudEventEmitted(requestData, null, null, consumer);
        this.testDefaultCloudEventEmitted(requestData, null, false, consumer);
        this.testDefaultCloudEventEmitted(requestData, null, true, consumer);
        this.testDefaultCloudEventEmitted(requestData, false, null, consumer);
        this.testDefaultCloudEventEmitted(requestData, false, false, consumer);
        this.testDefaultCloudEventEmitted(requestData, false, true, consumer);
        this.testFullCloudEventEmitted(requestData, true, null, consumer);
        this.testFullCloudEventEmitted(requestData, true, false, consumer);
        this.testFullCloudEventEmitted(requestData, true, true, consumer);
    }

    static {
        objectMapper = CloudEventUtils.Mapper.mapper();
    }

    private static class TestEventReceiver
    implements EventReceiver {
        private Subscription subscription;
        private CloudEventUnmarshallerFactory unmarshaller = new ObjectCloudEventUnmarshallerFactory(objectMapper);

        private TestEventReceiver() {
        }

        public void accept(String message) throws IOException {
            this.subscription.getConsumer().apply(this.subscription.getConverter().convert((Object)message));
        }

        public <T> void subscribe(Function<DataEvent<T>, CompletionStage<?>> consumer, Class<T> clazz) {
            this.subscription = new Subscription(consumer, (Converter)new CloudEventConverter(clazz, this.unmarshaller));
        }
    }

    private static class RequestData {
        private final String modelName;
        private final String modelNamespace;
        private final String decision;
        private final String data;

        public RequestData(String modelName, String modelNamespace, String decision, String data) {
            this.modelName = modelName;
            this.modelNamespace = modelNamespace;
            this.decision = decision;
            this.data = data;
        }

        public String getModelName() {
            return this.modelName;
        }

        public String getModelNamespace() {
            return this.modelNamespace;
        }

        public String getDecision() {
            return this.decision;
        }

        public String getData() {
            return this.data;
        }
    }

    @FunctionalInterface
    private static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

