/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.eventdriven.rules;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.provider.ExtensionProvider;
import io.cloudevents.jackson.JsonCloudEventData;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.EventUnmarshaller;
import org.kie.kogito.event.SubscriptionInfo;
import org.kie.kogito.event.cloudevents.extension.KogitoRulesExtension;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.eventdriven.rules.EventDrivenQueryExecutor;
import org.kie.kogito.eventdriven.rules.RulesResponseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDrivenRulesController {
    public static final String REQUEST_EVENT_TYPE = "RulesRequest";
    public static final String RESPONSE_EVENT_TYPE = "RulesResponse";
    public static final String RESPONSE_ERROR_EVENT_TYPE = "RulesResponseError";
    private static final Logger LOG = LoggerFactory.getLogger(EventDrivenRulesController.class);
    private Map<String, EventDrivenQueryExecutor> executors;
    private ConfigBean config;
    private EventEmitter eventEmitter;
    private EventReceiver eventReceiver;
    private EventUnmarshaller<Object> eventUnmarshaller;

    protected EventDrivenRulesController() {
    }

    protected EventDrivenRulesController(Iterable<EventDrivenQueryExecutor> executors, ConfigBean config, EventEmitter eventEmitter, EventReceiver eventReceiver, EventUnmarshaller<Object> eventUnmarshaller) {
        this.executors = EventDrivenRulesController.buildExecutorsMap(executors);
        this.config = config;
        this.eventEmitter = eventEmitter;
        this.eventReceiver = eventReceiver;
        this.eventUnmarshaller = eventUnmarshaller;
    }

    protected void init(Iterable<EventDrivenQueryExecutor> executors, ConfigBean config, EventEmitter eventEmitter, EventReceiver eventReceiver, EventUnmarshaller<Object> eventUnmarshaller) {
        this.executors = EventDrivenRulesController.buildExecutorsMap(executors);
        this.config = config;
        this.eventEmitter = eventEmitter;
        this.eventReceiver = eventReceiver;
        this.eventUnmarshaller = eventUnmarshaller;
    }

    protected void subscribe() {
        this.eventReceiver.subscribe(this::handleRequest, SubscriptionInfo.builder().converter(this.eventUnmarshaller).outputClass(CloudEvent.class).createSubscriptionInfo());
    }

    private CompletionStage<Void> handleRequest(CloudEvent event) {
        this.validateRequest(event).flatMap(this::buildEvaluationContext).map(this::processRequest).flatMap(this::buildResponseCloudEvent).flatMap(CloudEventUtils::toDataEvent).ifPresent(e -> this.eventEmitter.emit(e, (String)e.get("type"), Optional.empty()));
        return CompletableFuture.completedFuture(null);
    }

    private Optional<CloudEvent> validateRequest(CloudEvent event) {
        return Optional.ofNullable(event).filter(e -> REQUEST_EVENT_TYPE.equals(e.getType()));
    }

    private Optional<EvaluationContext> buildEvaluationContext(CloudEvent event) {
        KogitoRulesExtension extension = (KogitoRulesExtension)ExtensionProvider.getInstance().parseExtension(KogitoRulesExtension.class, (CloudEventExtensions)event);
        Map data = CloudEventUtils.decodeMapData((CloudEvent)event, String.class, Object.class).orElse(null);
        if (extension == null) {
            LOG.warn("Received CloudEvent(id={} source={} type={}) with null Kogito extension", new Object[]{event.getId(), event.getSource(), event.getType()});
        }
        if (data == null) {
            LOG.warn("Received CloudEvent(id={} source={} type={}) with null data", new Object[]{event.getId(), event.getSource(), event.getType()});
        }
        return Optional.of(new EvaluationContext(event, extension));
    }

    private EvaluationContext processRequest(EvaluationContext ctx) {
        if (!ctx.isValidRequest()) {
            ctx.setResponseError(RulesResponseError.BAD_REQUEST);
            return ctx;
        }
        Optional<EventDrivenQueryExecutor> optExecutor = this.getExecutor(ctx.getRuleUnitId(), ctx.getQueryName());
        if (!optExecutor.isPresent()) {
            ctx.setResponseError(RulesResponseError.QUERY_NOT_FOUND);
            return ctx;
        }
        EventDrivenQueryExecutor executor = optExecutor.get();
        try {
            Object result = executor.executeQuery(ctx.getRequestCloudEvent());
            ctx.setQueryResult(result);
        }
        catch (RuntimeException e) {
            LOG.error("Internal execution error", (Throwable)e);
            ctx.setResponseError(RulesResponseError.INTERNAL_EXECUTION_ERROR);
        }
        return ctx;
    }

    private Optional<EventDrivenQueryExecutor> getExecutor(String ruleUnitId, String queryName) {
        return Optional.ofNullable(this.executors.get(EventDrivenRulesController.buildExecutorId(ruleUnitId, queryName)));
    }

    private Optional<CloudEvent> buildResponseCloudEvent(EvaluationContext ctx) {
        String id = UUID.randomUUID().toString();
        URI source = this.buildResponseCloudEventSource(ctx);
        String subject = ctx.getRequestCloudEvent().getSubject();
        KogitoRulesExtension extension = new KogitoRulesExtension();
        extension.setRuleUnitId(ctx.getRuleUnitId());
        extension.setRuleUnitQuery(ctx.getQueryName());
        if (ctx.isResponseError()) {
            String data = Optional.ofNullable(ctx.getResponseError()).map(Enum::name).orElse(null);
            return CloudEventUtils.build((String)id, (URI)source, (String)RESPONSE_ERROR_EVENT_TYPE, (String)subject, (Object)data, (CloudEventExtension[])new CloudEventExtension[]{extension});
        }
        return CloudEventUtils.build((String)id, (URI)source, (String)RESPONSE_EVENT_TYPE, (String)subject, (Object)ctx.getQueryResult(), (CloudEventExtension[])new CloudEventExtension[]{extension});
    }

    private URI buildResponseCloudEventSource(EvaluationContext ctx) {
        return CloudEventUtils.buildDecisionSource((String)this.config.getServiceUrl(), (String)EventDrivenRulesController.toKebabCase(ctx.getQueryName()));
    }

    private static String buildExecutorId(String ruleUnitId, String queryName) {
        return String.format("%s#%s", ruleUnitId, queryName);
    }

    private static Map<String, EventDrivenQueryExecutor> buildExecutorsMap(Iterable<EventDrivenQueryExecutor> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toMap(e -> EventDrivenRulesController.buildExecutorId(e.getRuleUnitId(), e.getQueryName()), e -> e));
    }

    private static String toKebabCase(String inputString) {
        return inputString == null ? null : inputString.replaceAll("(.)(\\p{Upper})", "$1-$2").toLowerCase();
    }

    private static class EvaluationContext {
        private final CloudEvent requestCloudEvent;
        private final String ruleUnitId;
        private final String queryName;
        private final boolean validRequest;
        private RulesResponseError responseError;
        private Object queryResult;

        public EvaluationContext(CloudEvent requestCloudEvent, KogitoRulesExtension requestExtension) {
            this.requestCloudEvent = requestCloudEvent;
            this.ruleUnitId = Optional.ofNullable(requestExtension).map(KogitoRulesExtension::getRuleUnitId).orElse(null);
            this.queryName = Optional.ofNullable(requestExtension).map(KogitoRulesExtension::getRuleUnitQuery).orElse(null);
            this.validRequest = EvaluationContext.isValidCloudEvent(requestCloudEvent) && requestExtension != null && this.ruleUnitId != null && !this.ruleUnitId.isEmpty() && this.queryName != null && !this.queryName.isEmpty();
        }

        public CloudEvent getRequestCloudEvent() {
            return this.requestCloudEvent;
        }

        public String getRuleUnitId() {
            return this.ruleUnitId;
        }

        public String getQueryName() {
            return this.queryName;
        }

        public boolean isValidRequest() {
            return this.validRequest;
        }

        boolean isResponseError() {
            return this.queryResult == null;
        }

        public RulesResponseError getResponseError() {
            return this.responseError;
        }

        public void setResponseError(RulesResponseError responseError) {
            this.responseError = responseError;
        }

        public Object getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(Object queryResult) {
            this.queryResult = queryResult;
        }

        private static boolean isValidCloudEvent(CloudEvent event) {
            if (event == null || event.getData() == null) {
                return false;
            }
            if (event.getData() instanceof JsonCloudEventData) {
                JsonCloudEventData jced = (JsonCloudEventData)event.getData();
                return jced.getNode() != null && !jced.getNode().isNull();
            }
            return true;
        }
    }
}

