/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.eventdriven.rules;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.util.Optional;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.eventdriven.rules.EventDrivenQueryExecutor;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;
import org.kie.kogito.rules.RuleUnitQuery;

public abstract class AbstractEventDrivenQueryExecutor<D extends RuleUnitData, R>
implements EventDrivenQueryExecutor {
    private RuleUnit<D> ruleUnit;
    private String queryName;
    private Class<? extends RuleUnitQuery<R>> queryClass;
    private Class<D> dataClass;
    private ObjectMapper mapper;

    protected AbstractEventDrivenQueryExecutor() {
    }

    protected AbstractEventDrivenQueryExecutor(RuleUnit<D> ruleUnit, String queryName, Class<? extends RuleUnitQuery<R>> queryClass, Class<D> dataClass, ObjectMapper mapper) {
        this.ruleUnit = ruleUnit;
        this.queryName = queryName;
        this.queryClass = queryClass;
        this.dataClass = dataClass;
        this.mapper = mapper;
    }

    protected void setup(RuleUnit<D> ruleUnit, String queryName, Class<? extends RuleUnitQuery<R>> queryClass, Class<D> dataClass, ObjectMapper mapper) {
        this.ruleUnit = ruleUnit;
        this.queryName = queryName;
        this.queryClass = queryClass;
        this.dataClass = dataClass;
        this.mapper = mapper;
    }

    @Override
    public String getRuleUnitId() {
        return this.ruleUnit.id();
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public Object executeQuery(CloudEvent input) {
        return this.decodeData(input).map(this::internalExecuteQuery).orElseThrow(IllegalArgumentException::new);
    }

    private Optional<D> decodeData(CloudEvent input) {
        return this.mapper == null ? CloudEventUtils.decodeData((CloudEvent)input, this.dataClass) : CloudEventUtils.decodeData((CloudEvent)input, this.dataClass, (ObjectMapper)this.mapper);
    }

    private R internalExecuteQuery(D input) {
        RuleUnitInstance instance = this.ruleUnit.createInstance(input);
        Object response = instance.executeQuery(this.queryClass);
        instance.dispose();
        return (R)response;
    }
}

