/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.eventdriven.rules;

import java.util.function.Function;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.eventdriven.rules.EventDrivenQueryExecutor;
import org.kie.kogito.eventdriven.rules.EventDrivenRulesController;

public abstract class AbstractEventDrivenQueryExecutor<D extends RuleUnitData>
implements EventDrivenQueryExecutor<D> {
    private RuleUnit<D> ruleUnit;
    private String queryName;
    private Function<RuleUnitInstance<D>, Object> queryFunction;
    private Class<D> objectClass;

    protected AbstractEventDrivenQueryExecutor() {
    }

    protected AbstractEventDrivenQueryExecutor(EventDrivenRulesController controller, RuleUnit<D> ruleUnit, String queryName, Function<RuleUnitInstance<D>, Object> queryFunction, Class<D> objectClass) {
        this.setup(controller, ruleUnit, queryName, queryFunction, objectClass);
    }

    protected void setup(EventDrivenRulesController controller, RuleUnit<D> ruleUnit, String queryName, Function<RuleUnitInstance<D>, Object> queryFunction, Class<D> objectClass) {
        this.ruleUnit = ruleUnit;
        this.queryName = queryName;
        this.queryFunction = queryFunction;
        this.objectClass = objectClass;
        controller.subscribe(this, objectClass);
    }

    @Override
    public String getRuleUnitId() {
        return this.objectClass.getCanonicalName();
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public Object executeQuery(DataEvent<D> input) {
        return this.internalExecuteQuery((RuleUnitData)input.getData());
    }

    private Object internalExecuteQuery(D input) {
        try (RuleUnitInstance instance = this.ruleUnit.createInstance(input);){
            Object object = this.queryFunction.apply(instance);
            return object;
        }
    }

    public String toString() {
        return "AbstractEventDrivenQueryExecutor [ruleUnit=" + this.ruleUnit + ", queryName=" + this.queryName + ", objectClass=" + this.objectClass + "]";
    }
}

