/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.eventdriven.rules;

import io.cloudevents.CloudEventExtension;
import io.cloudevents.core.provider.ExtensionProvider;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.kie.kogito.config.ConfigBean;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.DataEventFactory;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.cloudevents.extension.KogitoRulesExtension;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.eventdriven.rules.EventDrivenQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDrivenRulesController {
    private static final String REQUEST_EVENT_TYPE = "RulesRequest";
    private static final String RESPONSE_EVENT_TYPE = "RulesResponse";
    private static final Logger LOG = LoggerFactory.getLogger(EventDrivenRulesController.class);
    private ConfigBean config;
    private EventEmitter eventEmitter;
    private EventReceiver eventReceiver;

    protected EventDrivenRulesController() {
    }

    protected EventDrivenRulesController(ConfigBean config, EventEmitter eventEmitter, EventReceiver eventReceiver) {
        this.init(config, eventEmitter, eventReceiver);
    }

    protected void init(ConfigBean config, EventEmitter eventEmitter, EventReceiver eventReceiver) {
        this.config = config;
        this.eventEmitter = eventEmitter;
        this.eventReceiver = eventReceiver;
    }

    public <D> void subscribe(EventDrivenQueryExecutor<D> queryExecutor, Class<D> objectClass) {
        this.eventReceiver.subscribe(new RequestHandler<D>(queryExecutor), objectClass);
    }

    private class RequestHandler<T>
    implements Function<DataEvent<T>, CompletionStage<?>> {
        private EventDrivenQueryExecutor<T> queryExecutor;

        public RequestHandler(EventDrivenQueryExecutor<T> queryExecutor) {
            this.queryExecutor = queryExecutor;
        }

        @Override
        public CompletionStage<?> apply(DataEvent<T> event) {
            KogitoRulesExtension extension = (KogitoRulesExtension)ExtensionProvider.getInstance().parseExtension(KogitoRulesExtension.class, event);
            if (CloudEventUtils.isValidRequest(event, (String)EventDrivenRulesController.REQUEST_EVENT_TYPE, (CloudEventExtension)extension)) {
                this.buildResponseCloudEvent(event, this.queryExecutor.executeQuery(event), extension).ifPresentOrElse(c -> EventDrivenRulesController.this.eventEmitter.emit(c), () -> LOG.info("Extension {} does not match this query executor {}", (Object)extension, this.queryExecutor));
            } else {
                LOG.warn("Event {} does not have expected information, discarding it", event);
            }
            return CompletableFuture.completedStage(null);
        }

        private Optional<DataEvent<?>> buildResponseCloudEvent(DataEvent<?> event, Object payload, KogitoRulesExtension extension) {
            return Objects.equals(this.queryExecutor.getRuleUnitId(), extension.getRuleUnitId()) && Objects.equals(this.queryExecutor.getQueryName(), extension.getRuleUnitQuery()) ? Optional.of(DataEventFactory.from((Object)payload, (String)EventDrivenRulesController.RESPONSE_EVENT_TYPE, (URI)CloudEventUtils.buildDecisionSource((String)EventDrivenRulesController.this.config.getServiceUrl(), (String)this.toKebabCase(this.queryExecutor.getQueryName())), Optional.ofNullable(event.getSubject()), (CloudEventExtension[])new CloudEventExtension[]{extension})) : Optional.empty();
        }

        private String toKebabCase(String inputString) {
            return inputString == null ? null : inputString.replaceAll("(.)(\\p{Upper})", "$1-$2").toLowerCase();
        }
    }
}

