/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.kogito.Application;
import org.kie.kogito.KogitoEngine;
import org.kie.kogito.StaticApplication;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.explainability.DmnDecisionModelSpy;
import org.kie.kogito.explainability.ExplainabilityService;
import org.kie.kogito.explainability.model.ModelIdentifier;
import org.kie.kogito.explainability.model.PredictInput;
import org.kie.kogito.explainability.model.PredictOutput;

public class ExplainabilityServiceTest {
    public static final String MODEL_RESOURCE = "/Traffic Violation.dmn";
    public static final String MODEL_NAMESPACE = "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF";
    public static final String MODEL_NAME = "Traffic Violation";
    static final String TEST_EXECUTION_ID = "test";
    static final DMNRuntime genericDMNRuntime = DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(ExplainabilityServiceTest.class.getResourceAsStream("/Traffic Violation.dmn"))});
    static final DmnDecisionModelSpy decisionModel = new DmnDecisionModelSpy(genericDMNRuntime, "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", () -> "test");

    @Test
    public void testPerturbedExecution() {
        DecisionModels decisionModels = (namespace, name) -> {
            if (MODEL_NAMESPACE.equals(namespace) && MODEL_NAME.equals(name)) {
                return decisionModel;
            }
            throw new RuntimeException("Model " + namespace + ":" + name + " not found.");
        };
        Map<String, Object> perturbedRequest = this.createRequest();
        PredictInput predictInput = new PredictInput(new ModelIdentifier("dmn", String.format("%s%s%s", MODEL_NAMESPACE, ":", MODEL_NAME)), perturbedRequest);
        StaticApplication application = new StaticApplication(null, new KogitoEngine[]{null, null, decisionModels, null});
        ExplainabilityService explainabilityService = ExplainabilityService.INSTANCE;
        List predictOutputs = explainabilityService.processRequest((Application)application, Collections.singletonList(predictInput));
        Assertions.assertEquals((int)1, (int)predictOutputs.size());
        PredictOutput predictOutput = (PredictOutput)predictOutputs.get(0);
        Assertions.assertNotNull((Object)predictOutput);
        Assertions.assertNotNull((Object)predictOutput.getResult());
        Map perturbedResult = predictOutput.getResult();
        Assertions.assertTrue((boolean)perturbedResult.containsKey("Should the driver be suspended?"));
        Assertions.assertEquals((Object)"No", perturbedResult.get("Should the driver be suspended?"));
        Assertions.assertTrue((boolean)perturbedResult.containsKey("Fine"));
        Assertions.assertNull(perturbedResult.get("Fine"));
        Assertions.assertTrue((boolean)decisionModel.getEvaluationSkipMonitoringHistory().stream().allMatch(x -> x.equals(true)));
    }

    private Map<String, Object> createRequest() {
        HashMap<String, Integer> driver = new HashMap<String, Integer>();
        driver.put("Age", 25);
        driver.put("Points", 10);
        HashMap<String, Object> violation = new HashMap<String, Object>();
        violation.put("Type", "speed");
        violation.put("Actual Speed", 105);
        violation.put("Speed Limit", 100);
        HashMap<String, Object> contextVariables = new HashMap<String, Object>();
        contextVariables.put("Driver", driver);
        contextVariables.put("Violation", violation);
        return contextVariables;
    }
}

