/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.kogito.Application;
import org.kie.kogito.explainability.DecisionExplainabilityResourceExecutor;
import org.kie.kogito.explainability.ExplainabilityResourceExecutor;
import org.kie.kogito.explainability.model.PredictInput;
import org.kie.kogito.explainability.model.PredictOutput;

public class ExplainabilityService {
    public static final ExplainabilityService INSTANCE = new ExplainabilityService(Collections.singletonList(new DecisionExplainabilityResourceExecutor()));
    private Collection<ExplainabilityResourceExecutor> executors;

    public ExplainabilityService(Collection<ExplainabilityResourceExecutor> executors) {
        this.executors = executors;
    }

    public List<PredictOutput> processRequest(Application application, List<PredictInput> predictInputs) {
        return predictInputs.stream().map(predictInput -> this.executors.stream().filter(r -> r.acceptRequest((PredictInput)predictInput)).map(r -> r.processRequest(application, (PredictInput)predictInput)).findFirst().orElseThrow(() -> new IllegalArgumentException("Malformed resourceType " + predictInput.getModelIdentifier().getResourceType()))).collect(Collectors.toList());
    }
}

