/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.predictions.smile;

import java.util.Collections;
import java.util.HashMap;
import org.drools.util.io.ClassPathResource;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.Resource;
import org.kie.kogito.Model;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.prediction.api.PredictionAwareHumanTaskLifeCycle;
import org.kie.kogito.prediction.api.PredictionService;
import org.kie.kogito.predictions.smile.AttributeType;
import org.kie.kogito.predictions.smile.RandomForestConfiguration;
import org.kie.kogito.predictions.smile.SmileRandomForest;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.CachedWorkItemHandlerConfig;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.process.impl.StaticProcessConfig;
import org.kie.kogito.process.workitem.LifeCycle;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;

public class SmileRandomForestPredictionTest {
    private PredictionService predictionService;
    private ProcessConfig config;

    @BeforeEach
    public void configure() {
        int i;
        RandomForestConfiguration configuration = new RandomForestConfiguration();
        HashMap<String, AttributeType> inputFeatures = new HashMap<String, AttributeType>();
        inputFeatures.put("ActorId", AttributeType.NOMINAL);
        configuration.setInputFeatures(inputFeatures);
        configuration.setOutcomeName("output");
        configuration.setOutcomeType(AttributeType.NOMINAL);
        configuration.setConfidenceThreshold(0.7);
        configuration.setNumTrees(1);
        this.predictionService = new SmileRandomForest(configuration);
        CachedWorkItemHandlerConfig wiConfig = new CachedWorkItemHandlerConfig();
        wiConfig.register("Human Task", (KogitoWorkItemHandler)new HumanTaskWorkItemHandler((LifeCycle)new PredictionAwareHumanTaskLifeCycle(this.predictionService)));
        this.config = new StaticProcessConfig((WorkItemHandlerConfig)wiConfig, (ProcessEventListenerConfig)new DefaultProcessEventListenerConfig(new ProcessEventListener[0]), (UnitOfWorkManager)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()), null);
        for (i = 0; i < 10; ++i) {
            this.predictionService.train(null, Collections.singletonMap("ActorId", "john"), Collections.singletonMap("output", "predicted value"));
        }
        for (i = 0; i < 8; ++i) {
            this.predictionService.train(null, Collections.singletonMap("ActorId", "mary"), Collections.singletonMap("output", "value"));
        }
    }

    @Test
    public void testUserTaskWithPredictionService() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((ProcessConfig)this.config, (Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)2, (int)result.toMap().size());
        Assertions.assertEquals((Object)"predicted value", result.toMap().get("s"));
    }
}

