/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.knative.eventing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.v1.CloudEventBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addon.cloudevents.message.MessagePayloadDecorator;
import org.kie.kogito.addon.cloudevents.message.MessagePayloadDecoratorProvider;
import org.kie.kogito.addons.knative.eventing.KnativeEventingMessagePayloadDecorator;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.mockito.Mockito;

class KnativeEventingMessagePayloadDecoratorTest {
    KnativeEventingMessagePayloadDecoratorTest() {
    }

    @Test
    public void verifyMergeFromValidCeOverrides() throws JsonProcessingException, URISyntaxException {
        ObjectMapper mapper = CloudEventUtils.Mapper.mapper();
        KnativeEventingMessagePayloadDecorator decorator = new KnativeEventingMessagePayloadDecorator();
        KnativeEventingMessagePayloadDecorator decoratorSpy = (KnativeEventingMessagePayloadDecorator)Mockito.spy((Object)decorator);
        Mockito.when((Object)decoratorSpy.readEnvCeOverrides()).thenReturn((Object)"{ \"extensions\": { \"kogitoaddons\": \"knative-eventing\"} }");
        CloudEvent ce = ((CloudEventBuilder)((CloudEventBuilder)new CloudEventBuilder().withType("unitTest").withSource(new URI("http://localhost")).withDataContentType("application/json").withId(UUID.randomUUID().toString()).withSubject("verifyMergeFromValidCeOverrides").withTime(OffsetDateTime.now()).withExtension("kogitorootprocid", "12345")).withData("{\"mykey\": \"myvalue\"}".getBytes(StandardCharsets.UTF_8))).build();
        String ceMarshalled = decoratorSpy.decorate(mapper.writeValueAsString((Object)ce));
        Assertions.assertThat((String)ceMarshalled).isNotNull();
        CloudEvent ceOverride = (CloudEvent)mapper.readValue(ceMarshalled, CloudEvent.class);
        Assertions.assertThat((Object)ceOverride).isNotNull();
        Assertions.assertThat((Object)ceOverride.getExtension("kogitoaddons")).isEqualTo((Object)"knative-eventing");
        Assertions.assertThat((Object)ceOverride.getExtension("kogitorootprocid")).isEqualTo((Object)"12345");
        Assertions.assertThat((Collection)ceOverride.getExtensionNames()).hasSize(2);
    }

    @Test
    public void verifyMergeFromExistingExtension() throws JsonProcessingException, URISyntaxException {
        ObjectMapper mapper = CloudEventUtils.Mapper.mapper();
        KnativeEventingMessagePayloadDecorator decorator = new KnativeEventingMessagePayloadDecorator();
        KnativeEventingMessagePayloadDecorator decoratorSpy = (KnativeEventingMessagePayloadDecorator)Mockito.spy((Object)decorator);
        Mockito.when((Object)decoratorSpy.readEnvCeOverrides()).thenReturn((Object)"{ \"extensions\": { \"kogitorootprocid\": \"54321\"} }");
        CloudEvent ce = ((CloudEventBuilder)((CloudEventBuilder)new CloudEventBuilder().withType("unitTest").withSource(new URI("http://localhost")).withDataContentType("application/json").withId(UUID.randomUUID().toString()).withSubject("verifyMergeFromExistingExtension").withTime(OffsetDateTime.now()).withExtension("kogitorootprocid", "12345")).withData("{\"mykey\": \"myvalue\"}".getBytes(StandardCharsets.UTF_8))).build();
        String ceMarshalled = decoratorSpy.decorate(mapper.writeValueAsString((Object)ce));
        Assertions.assertThat((String)ceMarshalled).isNotNull();
        CloudEvent ceOverride = (CloudEvent)mapper.readValue(ceMarshalled, CloudEvent.class);
        Assertions.assertThat((Object)ceOverride).isNotNull();
        Assertions.assertThat((Object)ceOverride.getExtension("kogitorootprocid")).isEqualTo((Object)"54321");
        Assertions.assertThat((Collection)ceOverride.getExtensionNames()).hasSize(1);
    }

    @Test
    public void verifyKnativeEventingDecoratorLoader() {
        MessagePayloadDecoratorProvider provider = MessagePayloadDecoratorProvider.getInstance();
        boolean found = false;
        for (MessagePayloadDecorator decorator : provider.getPayloadDecorators()) {
            if (!(decorator instanceof KnativeEventingMessagePayloadDecorator)) continue;
            found = true;
            break;
        }
        Assertions.assertThat((boolean)found).isTrue();
    }

    @Test
    public void verifyEmptyCeOverrides() throws URISyntaxException, JsonProcessingException {
        ObjectMapper mapper = CloudEventUtils.Mapper.mapper();
        KnativeEventingMessagePayloadDecorator decorator = new KnativeEventingMessagePayloadDecorator();
        KnativeEventingMessagePayloadDecorator decoratorSpy = (KnativeEventingMessagePayloadDecorator)Mockito.spy((Object)decorator);
        Mockito.when((Object)decoratorSpy.readEnvCeOverrides()).thenReturn((Object)"");
        CloudEvent ce = ((CloudEventBuilder)((CloudEventBuilder)new CloudEventBuilder().withType("unitTest").withSource(new URI("http://localhost")).withDataContentType("application/json").withId(UUID.randomUUID().toString()).withSubject("verifyMergeFromExistingExtension").withTime(OffsetDateTime.now()).withExtension("kogitorootprocid", "12345")).withData("{\"mykey\": \"myvalue\"}".getBytes(StandardCharsets.UTF_8))).build();
        String ceMarshalled = decoratorSpy.decorate(mapper.writeValueAsString((Object)ce));
        Assertions.assertThat((String)ceMarshalled).isNotNull();
        CloudEvent ceOverride = (CloudEvent)mapper.readValue(ceMarshalled, CloudEvent.class);
        Assertions.assertThat((Object)ceOverride).isNotNull();
        Assertions.assertThat((Collection)ceOverride.getExtensionNames()).hasSize(1);
    }

    @Test
    public void verifyInvalidCeOverrides() throws URISyntaxException, JsonProcessingException {
        ObjectMapper mapper = CloudEventUtils.Mapper.mapper();
        KnativeEventingMessagePayloadDecorator decorator = new KnativeEventingMessagePayloadDecorator();
        KnativeEventingMessagePayloadDecorator decoratorSpy = (KnativeEventingMessagePayloadDecorator)Mockito.spy((Object)decorator);
        Mockito.when((Object)decoratorSpy.readEnvCeOverrides()).thenReturn((Object)"{ \"kogitorootprocid\": \"54321\"}");
        CloudEvent ce = ((CloudEventBuilder)((CloudEventBuilder)new CloudEventBuilder().withType("unitTest").withSource(new URI("http://localhost")).withDataContentType("application/json").withId(UUID.randomUUID().toString()).withSubject("verifyMergeFromExistingExtension").withTime(OffsetDateTime.now()).withExtension("kogitorootprocid", "12345")).withData("{\"mykey\": \"myvalue\"}".getBytes(StandardCharsets.UTF_8))).build();
        String ceMarshalled = decoratorSpy.decorate(mapper.writeValueAsString((Object)ce));
        Assertions.assertThat((String)ceMarshalled).isNotNull();
        CloudEvent ceOverride = (CloudEvent)mapper.readValue(ceMarshalled, CloudEvent.class);
        Assertions.assertThat((Object)ceOverride).isNotNull();
        Assertions.assertThat((Collection)ceOverride.getExtensionNames()).hasSize(1);
    }
}

