/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.k8s;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addons.k8s.Endpoint;
import org.kie.kogito.addons.k8s.EndpointBuilder;

class EndpointBuilderTest {
    EndpointBuilderTest() {
    }

    @Test
    public void testBuildFromService() {
        EndpointBuilder builder = new EndpointBuilder();
        HashMap<Service, String> testCases = new HashMap<Service, String>();
        Service httpService = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withClusterIP("127.0.0.1")).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(8080))).build()})).build())).build();
        testCases.put(httpService, "http://127.0.0.1:8080");
        Service httpsService = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc2")).endMetadata()).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withClusterIP("127.0.0.1")).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("https")).withPort(Integer.valueOf(8443))).build()})).build())).build();
        testCases.put(httpsService, "https://127.0.0.1:8443");
        Service httpAndHttpsService = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc2")).endMetadata()).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withClusterIP("127.0.0.1")).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(8080))).build(), ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("https")).withPort(Integer.valueOf(8443))).build()})).build())).build();
        testCases.put(httpAndHttpsService, "https://127.0.0.1:8443");
        Service secureServiceNonConventionalPort = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc3")).endMetadata()).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withClusterIP("127.0.0.1")).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("https")).withPort(Integer.valueOf(5443))).build()})).build())).build();
        testCases.put(secureServiceNonConventionalPort, "https://127.0.0.1:5443");
        Service randomService = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc4")).endMetadata()).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withClusterIP("127.0.0.1")).withPorts(new ServicePort[]{((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8775))).build()})).build())).build();
        testCases.put(randomService, "http://127.0.0.1:8775");
        Service multiplePorts = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc5")).withLabels(Collections.singletonMap("primary-port-name", "niceport"))).endMetadata()).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withClusterIP("127.0.0.1")).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8080))).withName("niceport")).build(), ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8775))).withName("randomport")).build()})).build())).build();
        testCases.put(multiplePorts, "http://127.0.0.1:8080");
        testCases.forEach((s, e) -> {
            Endpoint endpoint = builder.buildFrom(s);
            ((AbstractStringAssert)Assertions.assertThat((String)endpoint.getUrl()).as("Failed to assert test case for service " + s.getMetadata().getName(), new Object[0])).isEqualTo(e);
        });
    }

    @Test
    public void testMultiplePortsWithPrimaryLabel() {
        Service multiplePorts = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc5")).withLabels(Collections.singletonMap("primary-port-name", "niceport"))).endMetadata()).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withClusterIP("127.0.0.1")).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8080))).withName("niceport")).build(), ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8775))).withName("randomport")).build()})).build())).build();
        Endpoint endpoint = new EndpointBuilder().buildFrom(multiplePorts);
        Assertions.assertThat((String)endpoint.getUrl()).isEqualTo("http://127.0.0.1:8080");
        Assertions.assertThat((Map)endpoint.getSecondaryURLs()).hasSize(1);
        Assertions.assertThat((String)endpoint.getSecondaryUrl("randomport")).isEqualTo("http://127.0.0.1:8775");
        Assertions.assertThat((Map)endpoint.getLabels()).isNotEmpty();
    }

    @Test
    public void testMultipleValidPorts() {
        Service multiplePorts = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc7")).withLabels(Collections.singletonMap("primary-port-name", "niceport"))).endMetadata()).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withClusterIP("127.0.0.1")).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8080))).withName("http")).build(), ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8443))).withName("https")).build(), ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8778))).withName("randomport")).build()})).build())).build();
        Endpoint endpoint = new EndpointBuilder().buildFrom(multiplePorts);
        Assertions.assertThat((String)endpoint.getUrl()).isEqualTo("https://127.0.0.1:8443");
        Assertions.assertThat((Map)endpoint.getSecondaryURLs()).hasSize(2);
        Assertions.assertThat((String)endpoint.getSecondaryUrl("http")).isEqualTo("http://127.0.0.1:8080");
        Assertions.assertThat((String)endpoint.getSecondaryUrl("randomport")).isEqualTo("http://127.0.0.1:8778");
        Assertions.assertThat((Map)endpoint.getLabels()).isNotEmpty();
    }

    @Test
    public void testMultipleValidPortsAndLabel() {
        Service multiplePorts = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc7")).withLabels(Collections.singletonMap("primary-port-name", "niceport"))).endMetadata()).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withClusterIP("127.0.0.1")).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8080))).withName("http")).build(), ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8443))).withName("https")).build(), ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(8181))).withName("niceport")).build()})).build())).build();
        Endpoint endpoint = new EndpointBuilder().buildFrom(multiplePorts);
        Assertions.assertThat((String)endpoint.getUrl()).isEqualTo("http://127.0.0.1:8181");
        Assertions.assertThat((Map)endpoint.getSecondaryURLs()).hasSize(2);
        Assertions.assertThat((String)endpoint.getSecondaryUrl("http")).isEqualTo("http://127.0.0.1:8080");
        Assertions.assertThat((String)endpoint.getSecondaryUrl("https")).isEqualTo("https://127.0.0.1:8443");
        Assertions.assertThat((Map)endpoint.getLabels()).isNotEmpty();
    }
}

