/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.k8s;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.kogito.addons.k8s.Endpoint;
import org.kie.kogito.addons.k8s.EndpointDiscovery;

public class EndpointDiscoveryComposite
implements EndpointDiscovery {
    private final List<EndpointDiscovery> endpointDiscoveryList = new LinkedList<EndpointDiscovery>();

    public EndpointDiscoveryComposite(EndpointDiscovery ... endpointDiscovery) {
        this.endpointDiscoveryList.addAll(Arrays.asList(endpointDiscovery));
    }

    public void add(EndpointDiscovery endpointDiscovery) {
        this.endpointDiscoveryList.add(endpointDiscovery);
    }

    @Override
    public Optional<Endpoint> findEndpoint(String namespace, String name) {
        for (EndpointDiscovery e : this.endpointDiscoveryList) {
            Optional<Endpoint> endpoint = e.findEndpoint(namespace, name);
            if (!endpoint.isPresent()) continue;
            return endpoint;
        }
        return Optional.empty();
    }

    @Override
    public List<Endpoint> findEndpoint(String namespace, Map<String, String> labels) {
        List<Endpoint> endpoints = Collections.emptyList();
        for (EndpointDiscovery e : this.endpointDiscoveryList) {
            endpoints = e.findEndpoint(namespace, labels);
            if (endpoints.isEmpty()) continue;
            return endpoints;
        }
        return endpoints;
    }
}

