/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.k8s;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.serving.v1.Route;
import io.fabric8.knative.serving.v1.RouteList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.kogito.addons.k8s.Endpoint;
import org.kie.kogito.addons.k8s.EndpointDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnativeRouteEndpointDiscovery
implements EndpointDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnativeRouteEndpointDiscovery.class);
    KnativeClient knativeClient;

    public KnativeRouteEndpointDiscovery(KubernetesClient kubernetesClient) {
        this.adaptKnativeClientFromKube(kubernetesClient);
    }

    public void setKnativeClient(KnativeClient knativeClient) {
        this.knativeClient = knativeClient;
    }

    public final void adaptKnativeClientFromKube(KubernetesClient kubernetesClient) {
        try {
            if (kubernetesClient != null && kubernetesClient.isAdaptable(KnativeClient.class).booleanValue()) {
                this.knativeClient = (KnativeClient)kubernetesClient.adapt(KnativeClient.class);
            } else {
                LOGGER.warn("Impossible to adapt Fabric8 Kubernetes Client to Knative Client. Discovery operations for Knative won't be performed.");
            }
        }
        catch (KubernetesClientException ex) {
            LOGGER.warn("Error trying to adapt current Kubernetes Client to Knative. Turn on DEBUG to see the full stack trace: {}", (Object)ex.getMessage());
            LOGGER.debug("Stack trace: ", (Throwable)ex);
        }
    }

    @Override
    public Optional<Endpoint> findEndpoint(String namespace, String name) {
        if (this.knativeClient == null) {
            LOGGER.debug("Knative Client unavailable, skipping Knative Endpoints discovery");
            return Optional.empty();
        }
        Route route = (Route)((Resource)((NonNamespaceOperation)this.knativeClient.routes().inNamespace(namespace)).withName(name)).get();
        if (route == null || route.getStatus() == null) {
            return Optional.empty();
        }
        return Optional.of(new Endpoint(route.getStatus().getUrl()));
    }

    @Override
    public List<Endpoint> findEndpoint(String namespace, Map<String, String> labels) {
        if (this.knativeClient == null) {
            LOGGER.debug("Knative Client unavailable, skipping Knative Endpoints discovery");
            return Collections.emptyList();
        }
        List routes = ((RouteList)((FilterWatchListDeletable)((NonNamespaceOperation)this.knativeClient.routes().inNamespace(namespace)).withLabels(labels)).list()).getItems();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        routes.forEach(r -> endpoints.add(new Endpoint(r.getStatus().getUrl())));
        return endpoints;
    }
}

