/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.avro;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.avro.AvroMapper;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.jackson.JsonCloudEventData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.util.Utf8;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;

public class AvroIO {
    private static final String ATTRIBUTES = "attribute";
    private static final Utf8 SPEC_VERSION_UTF = new Utf8("specversion");
    public static final String CLOUD_EVENT_SCHEMA_NAME = "spec.avsc";
    public static final String JSON_NODE_SCHEMA_NAME = "jsonNode.avsc";
    private final Schema ceSchema = AvroIO.loadSchema("spec.avsc");
    private final Schema jsonSchema = AvroIO.loadSchema("jsonNode.avsc");
    private final AvroMapper avroMapper = AvroIO.getAvroMapper();

    public ObjectMapper getObjectMapper() {
        return this.avroMapper;
    }

    public byte[] writeObject(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.avroMapper.writer((FormatSchema)this.getAvroSchema(obj.getClass())).writeValue((OutputStream)out, obj);
        out.flush();
        return out.toByteArray();
    }

    public <T> T readObject(byte[] payload, Class<T> outputClass, Class<?> ... parametrizedClasses) throws IOException {
        JavaType type = Objects.isNull(parametrizedClasses) ? this.avroMapper.getTypeFactory().constructType(outputClass) : this.avroMapper.getTypeFactory().constructParametricType(outputClass, (Class[])parametrizedClasses);
        return (T)this.avroMapper.readerFor(type).with((FormatSchema)this.getAvroSchema(outputClass)).readValue(payload);
    }

    public byte[] writeCloudEvent(CloudEvent event) throws IOException {
        GenericDatumWriter writer = new GenericDatumWriter(this.ceSchema);
        GenericRecordBuilder builder = new GenericRecordBuilder(this.ceSchema);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)bytes, null);
        Map<String, Object> attrsMap = event.getAttributeNames().stream().collect(Collectors.toMap(k -> k, k -> this.fromJavaObject(event.getAttribute(k))));
        attrsMap.putAll(event.getExtensionNames().stream().collect(Collectors.toMap(k -> k, k -> this.fromJavaObject(event.getExtension(k)))));
        builder.set(ATTRIBUTES, attrsMap);
        CloudEventData data = event.getData();
        if (data instanceof JsonCloudEventData) {
            builder.set("data", this.avroMapper.convertValue((Object)((JsonCloudEventData)data).getNode(), Map.class));
        } else if (data != null) {
            builder.set("data", (Object)ByteBuffer.wrap(data.toBytes()));
        }
        writer.write((Object)builder.build(), (Encoder)encoder);
        encoder.flush();
        return bytes.toByteArray();
    }

    private Object fromJavaObject(Object value) {
        if (value instanceof Number || value instanceof Boolean || value instanceof String || value instanceof ByteBuffer) {
            return value;
        }
        if (value instanceof byte[]) {
            return ByteBuffer.wrap((byte[])value);
        }
        return value.toString();
    }

    public CloudEvent readCloudEvent(byte[] bytes) throws IOException {
        GenericDatumReader reader = new GenericDatumReader(this.ceSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, null);
        GenericRecord record = (GenericRecord)reader.read(null, (Decoder)decoder);
        Map attrs = (Map)record.get(ATTRIBUTES);
        SpecVersion specVersion = SpecVersion.parse((String)attrs.remove(SPEC_VERSION_UTF).toString());
        CloudEventBuilder builder = CloudEventBuilder.fromSpecVersion((SpecVersion)specVersion);
        specVersion.getAllAttributes().forEach(k -> {
            Object v = attrs.remove(new Utf8(k));
            if (v != null) {
                CloudEventUtils.withAttribute((CloudEventBuilder)builder, (String)k, v);
            }
        });
        Object data = record.get("data");
        if (data instanceof ByteBuffer) {
            builder.withData(((ByteBuffer)data).array());
        } else if (data instanceof Map) {
            builder.withData((CloudEventData)JsonCloudEventData.wrap((JsonNode)((JsonNode)this.avroMapper.convertValue(data, JsonNode.class))));
        }
        attrs.forEach((k, v) -> CloudEventUtils.withExtension((CloudEventBuilder)builder, (String)k.toString(), (Object)v));
        return builder.build();
    }

    private AvroSchema getAvroSchema(Class<?> clazz) {
        return new AvroSchema(this.getSchema(clazz));
    }

    private Schema getSchema(Class<?> clazz) {
        return JsonNode.class.isAssignableFrom(clazz) ? this.jsonSchema : ReflectData.get().getSchema(clazz);
    }

    private static Schema loadSchema(String schemaName) throws IOException {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaName);){
            if (is == null) {
                throw new IOException("cannot load cloud event schema");
            }
            Schema schema = new Schema.Parser().parse(is);
            return schema;
        }
    }

    private static final AvroMapper getAvroMapper() {
        AvroMapper mapper = new AvroMapper();
        mapper.findAndRegisterModules().registerModule((Module)new SimpleModule().addSerializer(Utf8.class, (JsonSerializer)new JsonSerializer<Utf8>(){

            public void serialize(Utf8 value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        }));
        return mapper;
    }
}

